/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import java.util.List;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.EndpointInvocationContextImpl;
import org.apache.axis2.jaxws.server.InvocationListener;
import org.apache.axis2.jaxws.server.InvocationListenerBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InvocationHelper {
    private static final Log log = LogFactory.getLog(InvocationHelper.class);

    public static void callListenersForException(Throwable t, MessageContext context) {
        EndpointInvocationContextImpl eic = new EndpointInvocationContextImpl();
        eic.setRequestMessageContext(context);
        eic.setInvocationListeners((List)context.getProperty("org.apache.axis2.jaxws.spi.INVOCATION_LISTENER_LIST"));
        InvocationHelper.callListenersForException(t, eic);
    }

    public static void callListenersForException(Throwable t, EndpointInvocationContext eic) {
        List<InvocationListener> invocationListeners = eic.getInvocationListeners();
        Object returnException = null;
        if (invocationListeners != null && !invocationListeners.isEmpty()) {
            InvocationListenerBean bean = new InvocationListenerBean();
            bean.setEndpointInvocationContext(eic);
            bean.setState(eic.getResponseMessageContext() != null ? InvocationListenerBean.State.RESPONSE : InvocationListenerBean.State.REQUEST);
            bean.setThrowable(t);
            for (InvocationListener listener : invocationListeners) {
                listener.notifyOnException(bean);
            }
        }
    }

    public static Throwable determineMappedException(Throwable t, EndpointInvocationContext eic) {
        Throwable returnThrowable = null;
        InvocationHelper.callListenersForException(t, eic);
        MessageContext requestContext = eic.getRequestMessageContext();
        MessageContext responseContext = eic.getResponseMessageContext();
        if (requestContext != null && requestContext.getProperty("org.apache.axis2.jaxws.spi.MAPPED_EXCEPTION") != null) {
            returnThrowable = (Throwable)requestContext.getProperty("org.apache.axis2.jaxws.spi.MAPPED_EXCEPTION");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting mapped exception to: " + returnThrowable + " from request " + "MessageContext"));
            }
        } else if (responseContext != null && responseContext.getProperty("org.apache.axis2.jaxws.spi.MAPPED_EXCEPTION") != null) {
            returnThrowable = (Throwable)responseContext.getProperty("org.apache.axis2.jaxws.spi.MAPPED_EXCEPTION");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting mapped exception to: " + returnThrowable + " from response " + "MessageContext"));
            }
        }
        return returnThrowable;
    }

    public static Throwable determineMappedException(Throwable t, MessageContext context) {
        EndpointInvocationContext eic = (EndpointInvocationContext)context.getInvocationContext();
        if (eic == null) {
            eic = new EndpointInvocationContextImpl();
            eic.setRequestMessageContext(context);
        }
        eic.setInvocationListeners((List)context.getProperty("org.apache.axis2.jaxws.spi.INVOCATION_LISTENER_LIST"));
        return InvocationHelper.determineMappedException(t, eic);
    }
}

