/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.datasource.jaxb.JAXBMTOMAwareOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBAttachmentMarshaller
extends AttachmentMarshaller {
    private static final Log log = LogFactory.getLog(JAXBAttachmentMarshaller.class);
    private MessageContext msgContext;
    private XMLStreamWriter writer;
    private static final String APPLICATION_OCTET = "application/octet-stream";

    public JAXBAttachmentMarshaller(MessageContext msgContext, XMLStreamWriter writer) {
        this.msgContext = msgContext;
        this.writer = writer;
    }

    public boolean isXOPPackage() {
        boolean value = false;
        value = this.isMTOMEnabled();
        if (!(this.writer instanceof MTOMXMLStreamWriter) && !(this.writer instanceof JAXBMTOMAwareOMBuilder)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The writer is not enabled for MTOM.  MTOM values will not be optimized");
            }
            value = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isXOPPackage returns " + value));
        }
        return value;
    }

    public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String namespace, String localPart) {
        if (offset != 0 || length != data.length) {
            int len = length - offset;
            byte[] newData = new byte[len];
            System.arraycopy(data, offset, newData, 0, len);
            data = newData;
        }
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = APPLICATION_OCTET;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding MTOM/XOP byte array attachment for element: {" + namespace + "}" + localPart));
        }
        String cid = null;
        try {
            int optimizedThreshold;
            InternetHeaders ih = new InternetHeaders();
            ih.setHeader("Content-Type", mimeType);
            MimeBodyPart mbp = new MimeBodyPart(ih, data);
            MimePartDataSource mpds = new MimePartDataSource((MimePart)mbp);
            long dataLength = data.length;
            Integer value = null;
            if (this.msgContext != null) {
                value = (Integer)this.msgContext.getProperty("mtomThreshold");
            }
            int n = optimizedThreshold = value != null ? value : 0;
            if (optimizedThreshold == 0 || dataLength > (long)optimizedThreshold) {
                DataHandler dataHandler = new DataHandler((DataSource)mpds);
                cid = this.addDataHandler(dataHandler);
            }
            mbp.setHeader("Content-Id", cid);
        }
        catch (MessagingException e) {
            throw new OMException((Throwable)e);
        }
        return cid == null ? null : "cid:" + cid;
    }

    public String addMtomAttachment(DataHandler data, String namespace, String localPart) {
        String cid;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding MTOM/XOP datahandler attachment for element: {" + namespace + "}" + localPart));
        }
        return (cid = this.addDataHandler(data)) == null ? null : "cid:" + cid;
    }

    public String addSwaRefAttachment(DataHandler data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding SWAREF attachment");
        }
        String cid = this.addDataHandler(data);
        this.setDoingSWA();
        return "cid:" + cid;
    }

    private String addDataHandler(DataHandler dh) {
        String cid = null;
        OMTextImpl textNode = null;
        if (this.writer instanceof MTOMXMLStreamWriter) {
            textNode = new OMTextImpl((Object)dh, null);
            if (((MTOMXMLStreamWriter)this.writer).isOptimizedThreshold((OMText)textNode)) {
                cid = textNode.getContentID();
                ((MTOMXMLStreamWriter)this.writer).writeOptimized((OMText)textNode);
                this.addDataHandler(dh, cid);
            }
        } else if (this.writer instanceof JAXBMTOMAwareOMBuilder) {
            ((JAXBMTOMAwareOMBuilder)this.writer).writeDataHandler(dh);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("   content id=" + cid));
            log.debug((Object)("   dataHandler  =" + dh));
        }
        return cid;
    }

    public boolean isMTOMEnabled() {
        if (this.msgContext == null) {
            return false;
        }
        String value = (String)this.msgContext.getProperty("enableMTOM");
        return "true".equalsIgnoreCase(value);
    }

    public void setDoingSWA() {
        if (this.msgContext != null) {
            this.msgContext.setDoingSwA(true);
            this.msgContext.setProperty("enableSwA", (Object)"true");
        }
    }

    public void addDataHandler(DataHandler dh, String cid) {
        if (this.msgContext != null) {
            this.msgContext.addAttachment(cid, dh);
        }
    }
}

