/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.factory.MessageContextFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.handler.HandlerPostInvoker;
import org.apache.axis2.jaxws.handler.HandlerPreInvoker;
import org.apache.axis2.jaxws.handler.LogicalMessageContext;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.handler.SOAPHeadersAdapter;
import org.apache.axis2.jaxws.handler.SoapMessageContext;
import org.apache.axis2.jaxws.handler.factory.HandlerPostInvokerFactory;
import org.apache.axis2.jaxws.handler.factory.HandlerPreInvokerFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.util.XMLFaultUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.SAAJFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainProcessor {
    private static final Log log = LogFactory.getLog(HandlerChainProcessor.class);
    private HandlerPreInvoker handlerPreInvoker = null;
    private HandlerPostInvoker handlerPostInvoker = null;
    private javax.xml.ws.handler.MessageContext currentMC;
    private LogicalMessageContext logicalMC = null;
    private SoapMessageContext soapMC = null;
    private MEPContext mepCtx;
    private List<Handler> handlers = null;
    private static final List<Handler> EMPTY_CHAIN = new ArrayList<Handler>();
    private static Handler currentHandler = null;
    private static String currentMethod = null;
    private int logicalLength = 0;
    private static final int SUCCESSFUL = 0;
    private static final int FAILED = 1;
    private static final int PROTOCOL_EXCEPTION = 2;
    private static final int OTHER_EXCEPTION = 3;
    private RuntimeException savedException;
    private Protocol proto;
    private static boolean soap_headers_adapter_called = false;
    private static boolean saaj_called = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerChainProcessor(List<Handler> chain, Protocol proto) {
        if (chain != null) {
            List<Handler> list = chain;
            synchronized (list) {
                if (chain.size() == 0) {
                    this.handlers = EMPTY_CHAIN;
                } else {
                    this.handlers = new ArrayList<Handler>();
                    this.handlers.addAll(chain);
                }
            }
        } else {
            this.handlers = EMPTY_CHAIN;
        }
        this.proto = proto;
    }

    private void sortChain() throws WebServiceException {
        if (this.handlers.size() == 0) {
            this.logicalLength = 0;
            return;
        }
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<SOAPHandler> protocolHandlers = new ArrayList<SOAPHandler>();
        for (Handler handler : this.handlers) {
            if (LogicalHandler.class.isAssignableFrom(handler.getClass())) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            if (SOAPHandler.class.isAssignableFrom(handler.getClass())) {
                protocolHandlers.add((SOAPHandler)handler);
                continue;
            }
            if (Handler.class.isAssignableFrom(handler.getClass())) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr1", (String)handler.getClass().getName()));
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr2", (String)handler.getClass().getName()));
        }
        this.logicalLength = logicalHandlers.size();
        this.handlers.clear();
        this.handlers.addAll(logicalHandlers);
        this.handlers.addAll(protocolHandlers);
    }

    public boolean processChain(MEPContext mepCtx, Direction direction, MEP mep, boolean expectResponse) {
        if (this.handlers.size() == 0) {
            return true;
        }
        this.mepCtx = mepCtx;
        this.sortChain();
        this.initContext(direction);
        boolean result = true;
        if (direction == Direction.OUT) {
            this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction == Direction.OUT ? 1 : 0));
            result = this.callGenericHandlers(mep, expectResponse, 0, this.handlers.size() - 1, direction);
        } else {
            this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction == Direction.OUT ? 1 : 0));
            result = this.callGenericHandlers(mep, expectResponse, this.handlers.size() - 1, 0, direction);
        }
        if ((Boolean)this.currentMC.get((Object)"javax.xml.ws.handler.message.outbound") != (direction == Direction.OUT)) {
            return false;
        }
        return result;
    }

    private boolean callGenericHandlers(MEP mep, boolean expectResponse, int start, int end, Direction direction) throws RuntimeException {
        if (mep == MEP.RESPONSE) {
            expectResponse = false;
        }
        int i = start;
        int result = 0;
        int newStart = 0;
        int newStart_inclusive = 0;
        int newEnd = 0;
        Direction newDirection = direction;
        if (direction == Direction.OUT) {
            while (i <= end && result == 0) {
                result = this.handleMessage(this.handlers.get(i), direction, expectResponse);
                newStart = i - 1;
                newStart_inclusive = i++;
                newEnd = 0;
                newDirection = Direction.IN;
                if (result != 0) continue;
                this.switchContext(direction, i);
            }
        } else {
            while (i >= end && result == 0) {
                result = this.handleMessage(this.handlers.get(i), direction, expectResponse);
                newStart = i + 1;
                newStart_inclusive = i--;
                newEnd = this.handlers.size() - 1;
                newDirection = Direction.OUT;
                if (result != 0) continue;
                this.switchContext(direction, i);
            }
        }
        if (newDirection == direction) {
            return true;
        }
        if (expectResponse) {
            if (result == 1) {
                this.mepCtx.getMessageContext().setOutbound(newDirection == Direction.OUT);
                SOAPHeadersAdapter.install(this.mepCtx.getMessageContext());
                this.callGenericHandlers_avoidRecursion(newStart, newEnd, newDirection);
                this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
            } else if (result == 2) {
                try {
                    this.mepCtx.getMessageContext().setOutbound(newDirection == Direction.OUT);
                    SOAPHeadersAdapter.install(this.mepCtx.getMessageContext());
                    this.callGenericHandleFault(newStart, newEnd, newDirection);
                    this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
                }
                catch (RuntimeException re) {
                    this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
                    throw re;
                }
            } else if (result == 3) {
                this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
                throw this.savedException;
            }
        } else if (mep.equals((Object)MEP.REQUEST)) {
            this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
            if (this.savedException != null) {
                log.warn((Object)"Exception thrown by a handler in one way invocation", (Throwable)this.savedException);
                return false;
            }
        } else {
            if (direction.equals((Object)Direction.IN)) {
                this.callCloseHandlers(this.handlers.size() - 1, 0, direction);
            } else {
                this.callCloseHandlers(0, this.handlers.size() - 1, direction);
            }
            if (this.savedException != null) {
                throw this.savedException;
            }
        }
        return true;
    }

    private void callGenericHandlers_avoidRecursion(int start, int end, Direction direction) {
        int i;
        if (direction == Direction.OUT) {
            for (i = start; i <= end; ++i) {
                this.switchContext(direction, i);
                Handler handler = this.handlers.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoking handleMessage on: " + handler.getClass().getName()));
                }
                this.callHandleMessageWithTracker(handler);
            }
        } else {
            while (i >= end) {
                this.switchContext(direction, i);
                Handler handler = this.handlers.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoking handleMessage on: " + handler.getClass().getName()));
                }
                this.callHandleMessageWithTracker(handler);
                --i;
            }
        }
    }

    private int handleMessage(Handler handler, Direction direction, boolean expectResponse) throws RuntimeException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking handleMessage on: " + handler.getClass().getName()));
            }
            this.currentMC.put((Object)"org.apache.axis2.jaxws.handler.MEPContext", (Object)this.mepCtx);
            this.getPreInvoker().preInvoke(this.currentMC);
            boolean success = this.callHandleMessageWithTracker(handler);
            this.getPostInvoker().postInvoke(this.currentMC);
            if (success) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"handleMessage() returned true");
                }
                return 0;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"handleMessage() returned false");
            }
            if (expectResponse) {
                this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction != Direction.OUT ? 1 : 0));
            }
            return 1;
        }
        catch (RuntimeException re) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"An exception was thrown during the handleMessage() invocation");
                log.debug((Object)"Exception: ", (Throwable)re);
            }
            this.savedException = re;
            if (expectResponse) {
                this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction != Direction.OUT ? 1 : 0));
            }
            if (ProtocolException.class.isAssignableFrom(re.getClass())) {
                HandlerChainProcessor.convertToFaultMessage(this.mepCtx, re, this.proto);
                return 2;
            }
            return 3;
        }
    }

    private void callCloseHandlers(int start, int end, Direction direction) {
        int i;
        if (direction == Direction.OUT) {
            for (i = start; i <= end; ++i) {
                try {
                    this.switchContext(direction, i);
                    Handler handler = this.handlers.get(i);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Invoking close on: " + handler.getClass().getName()));
                    }
                    this.callCloseWithTracker(handler);
                    continue;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"An Exception occurred while calling handler.close()");
                    log.debug((Object)("Exception: " + e.getClass().getName() + ":" + e.getMessage()));
                }
            }
        } else {
            while (i >= end) {
                block10: {
                    try {
                        this.switchContext(direction, i);
                        Handler handler = this.handlers.get(i);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Invoking close on: " + handler.getClass().getName()));
                        }
                        this.callCloseWithTracker(handler);
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block10;
                        log.debug((Object)"An Exception occurred while calling handler.close()");
                        log.debug((Object)("Exception: " + e.getClass().getName() + ":" + e.getMessage()));
                    }
                }
                --i;
            }
        }
    }

    public void processFault(MEPContext mepCtx, Direction direction) {
        if (this.handlers.size() == 0) {
            return;
        }
        this.mepCtx = mepCtx;
        this.sortChain();
        this.initContext(direction);
        this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction == Direction.OUT ? 1 : 0));
        try {
            if (direction == Direction.OUT) {
                this.callGenericHandleFault(0, this.handlers.size() - 1, direction);
            } else {
                this.callGenericHandleFault(this.handlers.size() - 1, 0, direction);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            if (direction == Direction.OUT) {
                this.initContext(Direction.IN);
                this.callCloseHandlers(0, this.handlers.size() - 1, Direction.OUT);
            } else {
                this.initContext(Direction.IN);
                this.callCloseHandlers(this.handlers.size() - 1, 0, Direction.IN);
            }
        }
    }

    private void callGenericHandleFault(int start, int end, Direction direction) throws RuntimeException {
        int i;
        this.switchContext(direction, i);
        if (direction == Direction.OUT) {
            for (i = start; i <= end; ++i) {
                boolean success;
                Handler handler = this.handlers.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoking handleFault on: " + handler.getClass().getName()));
                }
                if (success = this.callHandleFaultWithTracker(handler)) {
                    this.switchContext(direction, i + 1);
                    continue;
                }
                break;
            }
        } else {
            while (i >= end) {
                boolean success;
                Handler handler = this.handlers.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoking handleFault on: " + handler.getClass().getName()));
                }
                if (success = this.callHandleFaultWithTracker(handler)) {
                    this.switchContext(direction, i - 1);
                    --i;
                    continue;
                }
                break;
            }
        }
    }

    public static void convertToFaultMessage(MEPContext mepCtx, Exception e, Protocol protocol) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a fault Message object for the exception: " + e.getClass().getName()));
        }
        try {
            if (protocol != Protocol.soap11 && protocol != Protocol.soap12) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"cFaultMsgErr"));
            }
            String protocolNS = protocol == Protocol.soap11 ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
            XMLFault xmlFault = MethodMarshallerUtils.createXMLFaultFromSystemException(e);
            javax.xml.soap.MessageFactory mf = SAAJFactory.createMessageFactory(protocolNS);
            SOAPMessage message = mf.createMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPFault soapFault = XMLFaultUtils.createSAAJFault(xmlFault, body);
            MessageFactory msgFactory = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message msg = msgFactory.createFrom(message);
            mepCtx.setMessage(msg);
        }
        catch (Exception ex) {
            throw ExceptionFactory.makeWebServiceException((Throwable)ex);
        }
    }

    private void initContext(Direction direction) {
        this.soapMC = MessageContextFactory.createSoapMessageContext(this.mepCtx.getMessageContext());
        this.logicalMC = MessageContextFactory.createLogicalMessageContext(this.mepCtx.getMessageContext());
        this.currentMC = direction == Direction.OUT ? (this.logicalLength == 0 && this.handlers.size() > 0 ? this.soapMC : this.logicalMC) : (this.logicalLength == this.handlers.size() && this.handlers.size() > 0 ? this.logicalMC : this.soapMC);
    }

    private void switchContext(Direction direction, int index) {
        if (this.logicalLength == this.handlers.size() || this.logicalLength == 0) {
            return;
        }
        if (direction == Direction.OUT && index == this.logicalLength || direction == Direction.IN && index == this.logicalLength - 1) {
            this.currentMC = this.currentMC == this.logicalMC ? this.soapMC : this.logicalMC;
        }
    }

    private HandlerPreInvoker getPreInvoker() {
        if (this.handlerPreInvoker == null) {
            HandlerPreInvokerFactory preInvokerFactory = (HandlerPreInvokerFactory)FactoryRegistry.getFactory(HandlerPreInvokerFactory.class);
            this.handlerPreInvoker = preInvokerFactory.createHandlerPreInvoker();
        }
        return this.handlerPreInvoker;
    }

    private HandlerPostInvoker getPostInvoker() {
        if (this.handlerPostInvoker == null) {
            HandlerPostInvokerFactory postInvokerFactory = (HandlerPostInvokerFactory)FactoryRegistry.getFactory(HandlerPostInvokerFactory.class);
            this.handlerPostInvoker = postInvokerFactory.createHandlerPostInvoker();
        }
        return this.handlerPostInvoker;
    }

    public static void trackInternalCall(MessageContext mc, TRACKER tracker) {
        Object trackerProp;
        switch (tracker) {
            case SAAJ_CALLED: {
                saaj_called = true;
                break;
            }
            case SOAP_HEADERS_ADAPTER_CALLED: {
                soap_headers_adapter_called = true;
            }
        }
        Object object = trackerProp = mc == null ? null : mc.getProperty("org.apache.axis2.jaxws.handler.tracker");
        if (trackerProp != null && ((Boolean)trackerProp).booleanValue() && saaj_called && soap_headers_adapter_called && log.isDebugEnabled()) {
            String logString = "JAX-WS Handler implementations should not use the org.apache.axis2.jaxws.handler.tracker property to retrieve SOAP headers and manipulate the SOAP message using the SAAJ API in the same method implementation.  The Handler implementation and method doing this is: " + currentHandler.getClass().getName() + currentMethod;
            log.debug((Object)logString);
        }
    }

    private boolean callHandleMessageWithTracker(Handler handler) throws RuntimeException {
        currentHandler = handler;
        currentMethod = "handleMessage";
        this.currentMC.put((Object)"org.apache.axis2.jaxws.handler.tracker", (Object)true);
        boolean success = false;
        RuntimeException savedEx = null;
        try {
            success = handler.handleMessage(this.currentMC);
        }
        catch (RuntimeException t) {
            savedEx = t;
        }
        this.currentMC.put((Object)"org.apache.axis2.jaxws.handler.tracker", (Object)false);
        saaj_called = false;
        soap_headers_adapter_called = false;
        if (savedEx != null) {
            throw savedEx;
        }
        return success;
    }

    private boolean callHandleFaultWithTracker(Handler handler) {
        currentHandler = handler;
        currentMethod = "handleFault";
        this.currentMC.put((Object)"org.apache.axis2.jaxws.handler.tracker", (Object)true);
        boolean success = false;
        RuntimeException savedEx = null;
        try {
            success = handler.handleFault(this.currentMC);
        }
        catch (RuntimeException t) {
            savedEx = t;
        }
        this.currentMC.put((Object)"org.apache.axis2.jaxws.handler.tracker", (Object)false);
        saaj_called = false;
        soap_headers_adapter_called = false;
        if (savedEx != null) {
            throw savedEx;
        }
        return success;
    }

    private void callCloseWithTracker(Handler handler) {
        currentHandler = handler;
        currentMethod = "close";
        this.currentMC.put((Object)"org.apache.axis2.jaxws.handler.tracker", (Object)true);
        RuntimeException savedEx = null;
        try {
            handler.close(this.currentMC);
        }
        catch (RuntimeException t) {
            savedEx = t;
        }
        this.currentMC.put((Object)"org.apache.axis2.jaxws.handler.tracker", (Object)false);
        saaj_called = false;
        soap_headers_adapter_called = false;
        if (savedEx != null) {
            throw savedEx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TRACKER {
        SOAP_HEADERS_ADAPTER_CALLED,
        SAAJ_CALLED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MEP {
        REQUEST,
        RESPONSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        IN,
        OUT;

    }
}

