/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.AnnotationDescImpl;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.FaultBeanDescImpl;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArtifactProcessor {
    private static final Log log = LogFactory.getLog(ArtifactProcessor.class);
    private ServiceDescription serviceDesc;
    private Map<OperationDescription, String> requestWrapperMap = new HashMap<OperationDescription, String>();
    private Map<OperationDescription, String> responseWrapperMap = new HashMap<OperationDescription, String>();
    private Map<OperationDescription, Method> methodMap = new HashMap<OperationDescription, Method>();
    private Map<FaultDescription, FaultBeanDesc> faultBeanDescMap = new HashMap<FaultDescription, FaultBeanDesc>();
    static final String JAXWS_SUBPACKAGE = "jaxws";

    ArtifactProcessor(ServiceDescription serviceDesc) {
        this.serviceDesc = serviceDesc;
    }

    Map<OperationDescription, String> getRequestWrapperMap() {
        return this.requestWrapperMap;
    }

    Map<OperationDescription, String> getResponseWrapperMap() {
        return this.responseWrapperMap;
    }

    Map<FaultDescription, FaultBeanDesc> getFaultBeanDescMap() {
        return this.faultBeanDescMap;
    }

    Map<OperationDescription, Method> getMethodMap() {
        return this.methodMap;
    }

    void build() {
        for (EndpointDescription ed : this.serviceDesc.getEndpointDescriptions()) {
            if (ed.getEndpointInterfaceDescription() == null) continue;
            for (OperationDescription opDesc : ed.getEndpointInterfaceDescription().getOperations()) {
                Method method;
                Class cls;
                block17: {
                    String declaringClassName;
                    block16: {
                        String foundResponseWrapperName;
                        String responseWrapperName;
                        String foundRequestWrapperName;
                        declaringClassName = opDesc.getJavaDeclaringClassName();
                        String packageName = ArtifactProcessor.getPackageName(declaringClassName);
                        String simpleName = ArtifactProcessor.getSimpleClassName(declaringClassName);
                        String methodName = opDesc.getJavaMethodName();
                        String requestWrapperName = opDesc.getRequestWrapperClassName();
                        if (requestWrapperName == null) {
                            requestWrapperName = packageName.length() > 0 ? packageName + "." + ArtifactProcessor.javaMethodToClassName(methodName) : ArtifactProcessor.javaMethodToClassName(methodName);
                        }
                        if ((foundRequestWrapperName = ArtifactProcessor.findArtifact(requestWrapperName)) == null) {
                            foundRequestWrapperName = ArtifactProcessor.findArtifact(requestWrapperName, ed.getAxisService().getClassLoader());
                        }
                        if (foundRequestWrapperName == null) {
                            foundRequestWrapperName = this.missingArtifact(requestWrapperName);
                        }
                        if (foundRequestWrapperName != null) {
                            this.requestWrapperMap.put(opDesc, foundRequestWrapperName);
                        }
                        if ((responseWrapperName = opDesc.getResponseWrapperClassName()) == null) {
                            responseWrapperName = packageName.length() > 0 ? packageName + "." + ArtifactProcessor.javaMethodToClassName(methodName) + "Response" : ArtifactProcessor.javaMethodToClassName(methodName) + "Response";
                        }
                        if ((foundResponseWrapperName = ArtifactProcessor.findArtifact(responseWrapperName)) == null) {
                            foundResponseWrapperName = ArtifactProcessor.findArtifact(responseWrapperName, ed.getAxisService().getClassLoader());
                        }
                        if (foundResponseWrapperName == null) {
                            foundResponseWrapperName = this.missingArtifact(responseWrapperName);
                        }
                        if (foundResponseWrapperName != null) {
                            this.responseWrapperMap.put(opDesc, foundResponseWrapperName);
                        }
                        for (FaultDescription faultDesc : opDesc.getFaultDescriptions()) {
                            FaultBeanDesc faultBeanDesc = this.create(ed, faultDesc, opDesc);
                            this.faultBeanDescMap.put(faultDesc, faultBeanDesc);
                        }
                        cls = null;
                        try {
                            cls = ArtifactProcessor.loadClass(declaringClassName, ArtifactProcessor.getContextClassLoader());
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block16;
                            log.debug((Object)("Class " + declaringClassName + " was not found by the Context ClassLoader.  " + "Will use the ClassLoader associated with the service.  The exception is: " + e));
                        }
                    }
                    if (cls == null) {
                        try {
                            cls = ArtifactProcessor.loadClass(declaringClassName, ed.getAxisService().getClassLoader());
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block17;
                            log.debug((Object)("Class " + declaringClassName + " was not found by the AxisService ClassLoader.  " + "Processing continues.  The exception is:" + e));
                        }
                    }
                }
                if (cls == null || (method = ArtifactProcessor.getMethod(opDesc.getJavaMethodName(), cls)) == null) continue;
                this.methodMap.put(opDesc, method);
            }
        }
    }

    private FaultBeanDesc create(EndpointDescription ed, FaultDescription faultDesc, OperationDescription opDesc) {
        String faultBeanNamespace;
        String faultBeanLocalName;
        String foundClassName;
        String faultBeanClassName = faultDesc.getFaultBean();
        if (faultBeanClassName == null || faultBeanClassName.length() == 0) {
            faultBeanClassName = faultDesc.getFaultInfo();
        }
        if (faultBeanClassName == null || faultBeanClassName.length() == 0) {
            String declaringClassName = opDesc.getJavaDeclaringClassName();
            String packageName = ArtifactProcessor.getPackageName(declaringClassName);
            String simpleName = ArtifactProcessor.getSimpleClassName(faultDesc.getExceptionClassName());
            faultBeanClassName = packageName.length() > 0 ? packageName + "." + simpleName + "Bean" : simpleName + "Bean";
        }
        if ((foundClassName = ArtifactProcessor.findArtifact(faultBeanClassName)) == null) {
            faultBeanClassName = ArtifactProcessor.findArtifact(faultBeanClassName, ed.getAxisService().getClassLoader());
        }
        if (foundClassName == null) {
            faultBeanClassName = this.missingArtifact(faultBeanClassName);
        }
        if (foundClassName != null) {
            faultBeanClassName = foundClassName;
        }
        if (((faultBeanLocalName = faultDesc.getName()) == null || faultBeanLocalName.length() == 0) && faultBeanClassName != null && faultBeanClassName.length() > 0) {
            try {
                Class faultBean;
                try {
                    faultBean = ArtifactProcessor.loadClass(faultBeanClassName, ArtifactProcessor.getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    faultBean = ArtifactProcessor.loadClass(faultBeanClassName, ed.getAxisService().getClassLoader());
                }
                AnnotationDesc aDesc = AnnotationDescImpl.create(faultBean);
                if (aDesc.hasXmlRootElement()) {
                    faultBeanLocalName = aDesc.getXmlRootElementName();
                }
            }
            catch (Throwable t) {
                throw ExceptionFactory.makeWebServiceException((Throwable)t);
            }
        }
        if (faultBeanLocalName == null || faultBeanLocalName.length() == 0) {
            faultBeanLocalName = ArtifactProcessor.getSimpleClassName(faultDesc.getExceptionClassName()) + "Bean";
        }
        if (((faultBeanNamespace = faultDesc.getTargetNamespace()) == null || faultBeanNamespace.length() == 0) && faultBeanClassName != null && faultBeanClassName.length() > 0) {
            try {
                Class faultBean;
                try {
                    faultBean = ArtifactProcessor.loadClass(faultBeanClassName, ArtifactProcessor.getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    faultBean = ArtifactProcessor.loadClass(faultBeanClassName, ed.getAxisService().getClassLoader());
                }
                AnnotationDesc aDesc = AnnotationDescImpl.create(faultBean);
                if (aDesc.hasXmlRootElement()) {
                    faultBeanNamespace = aDesc.getXmlRootElementNamespace();
                }
            }
            catch (Throwable t) {
                throw ExceptionFactory.makeWebServiceException((Throwable)t);
            }
        }
        if (faultBeanNamespace == null || faultBeanNamespace.length() == 0) {
            faultBeanNamespace = opDesc.getEndpointInterfaceDescription().getTargetNamespace();
        }
        return new FaultBeanDescImpl(faultBeanClassName, faultBeanLocalName, faultBeanNamespace);
    }

    private static String getPackageName(String className) {
        int index = className.lastIndexOf(".");
        if (index <= 0) {
            return "";
        }
        return className.substring(0, index);
    }

    private static String getSimpleClassName(String className) {
        int index = className.lastIndexOf(".");
        if (index <= 0) {
            return className;
        }
        return className.substring(index + 1);
    }

    private static String javaMethodToClassName(String methodName) {
        String className = null;
        if (methodName != null) {
            StringBuffer buildClassName = new StringBuffer(methodName);
            buildClassName.replace(0, 1, methodName.substring(0, 1).toUpperCase());
            className = buildClassName.toString();
        }
        return className;
    }

    private String missingArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("The following class was not found: " + artifactName + " Processing continues without this class."));
        }
        return null;
    }

    private static String findArtifact(String artifactClassName) {
        return ArtifactProcessor.findArtifact(artifactClassName, ArtifactProcessor.getContextClassLoader());
    }

    private static String findArtifact(String artifactClassName, ClassLoader classLoader) {
        String originalPackage;
        String returnArtifactClassName = null;
        if (artifactClassName == null) {
            return returnArtifactClassName;
        }
        try {
            ArtifactProcessor.forName(artifactClassName, true, classLoader);
            returnArtifactClassName = artifactClassName;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (returnArtifactClassName == null && (originalPackage = ArtifactProcessor.getPackageName(artifactClassName)).length() > 0) {
            String alternatePackage = originalPackage + "." + JAXWS_SUBPACKAGE;
            String className = ArtifactProcessor.getSimpleClassName(artifactClassName);
            String alternateWrapperClass = alternatePackage + "." + className;
            try {
                ArtifactProcessor.loadClass(alternateWrapperClass, ArtifactProcessor.getContextClassLoader());
                returnArtifactClassName = alternateWrapperClass;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return returnArtifactClassName;
    }

    private static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return ArtifactProcessor.forName(className, true, classLoader);
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    try {
                        if (cls == null) {
                            cls = Class.forName(className, initialize, classloader);
                        }
                        return cls;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        return cls;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static Method getMethod(final String methodName, final Class cls) {
        Method method = null;
        try {
            method = (Method)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    Method[] methods = cls.getMethods();
                    if (methods != null) {
                        for (int i = 0; i < methods.length; ++i) {
                            if (!methods[i].getName().equals(methodName)) continue;
                            return methods[i];
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return method;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (RuntimeException)e.getException();
        }
        return cl;
    }
}

