/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.List;
import javax.xml.ws.handler.Handler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerInvokerUtils {
    private static Log log = LogFactory.getLog(HandlerInvokerUtils.class);

    public static boolean invokeInboundHandlers(MEPContext mepMessageCtx, List<Handler> handlers, HandlerChainProcessor.MEP mep, boolean isOneWay) {
        if (handlers == null || handlers.isEmpty()) {
            return true;
        }
        String bindingProto = null;
        bindingProto = mep.equals((Object)HandlerChainProcessor.MEP.REQUEST) ? mepMessageCtx.getEndpointDesc().getBindingType() : mepMessageCtx.getEndpointDesc().getClientBindingID();
        Protocol proto = Protocol.getProtocolForBinding(bindingProto);
        HandlerChainProcessor processor = new HandlerChainProcessor(handlers, proto);
        boolean success = true;
        try {
            if (mepMessageCtx.getMessageObject().isFault()) {
                processor.processFault(mepMessageCtx, HandlerChainProcessor.Direction.IN);
            } else {
                success = processor.processChain(mepMessageCtx, HandlerChainProcessor.Direction.IN, mep, !isOneWay);
            }
        }
        catch (RuntimeException re) {
            HandlerChainProcessor.convertToFaultMessage(mepMessageCtx, re, proto);
            mepMessageCtx.setApplicationAccessLocked(true);
            return false;
        }
        if (!success && mep.equals((Object)HandlerChainProcessor.MEP.REQUEST)) {
            mepMessageCtx.setApplicationAccessLocked(true);
            return false;
        }
        mepMessageCtx.setApplicationAccessLocked(true);
        return true;
    }

    public static boolean invokeOutboundHandlers(MEPContext mepMessageCtx, List<Handler> handlers, HandlerChainProcessor.MEP mep, boolean isOneWay) {
        if (handlers == null || handlers.isEmpty()) {
            return true;
        }
        String bindingProto = null;
        bindingProto = mep.equals((Object)HandlerChainProcessor.MEP.REQUEST) ? mepMessageCtx.getEndpointDesc().getClientBindingID() : mepMessageCtx.getEndpointDesc().getBindingType();
        Protocol proto = Protocol.getProtocolForBinding(bindingProto);
        HandlerChainProcessor processor = new HandlerChainProcessor(handlers, proto);
        boolean success = true;
        try {
            if (mepMessageCtx.getMessageObject().isFault()) {
                processor.processFault(mepMessageCtx, HandlerChainProcessor.Direction.OUT);
            } else {
                success = processor.processChain(mepMessageCtx, HandlerChainProcessor.Direction.OUT, mep, !isOneWay);
            }
        }
        catch (RuntimeException re) {
            HandlerChainProcessor.convertToFaultMessage(mepMessageCtx, re, proto);
            if (mepMessageCtx.getRequestMessageContext() != null) {
                mepMessageCtx.getRequestMessageContext().setCausedByException(new AxisFault(re.getMessage(), (Throwable)re));
            }
            if (mepMessageCtx.getResponseMessageContext() != null) {
                mepMessageCtx.getResponseMessageContext().setCausedByException(new AxisFault(re.getMessage(), (Throwable)re));
            }
            return false;
        }
        return success || !mep.equals((Object)HandlerChainProcessor.MEP.REQUEST);
    }

    public static boolean invokeInboundHandlersForClosure(MEPContext mepMessageCtx, List<Handler> handlers, HandlerChainProcessor.MEP mep) {
        if (handlers == null || handlers.isEmpty()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"invokeInboundHandlersForClosure Entry");
        }
        String bindingProto = null;
        bindingProto = mep.equals((Object)HandlerChainProcessor.MEP.REQUEST) ? mepMessageCtx.getEndpointDesc().getBindingType() : mepMessageCtx.getEndpointDesc().getClientBindingID();
        Protocol proto = Protocol.getProtocolForBinding(bindingProto);
        HandlerChainProcessor processor = new HandlerChainProcessor(handlers, proto);
        boolean success = true;
        try {
            success = processor.processChainForClose(mepMessageCtx, HandlerChainProcessor.Direction.OUT);
        }
        catch (RuntimeException re) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("invokeInboundHandlersForClosure caught exception from close: " + re));
                log.debug((Object)"invokeInboundHandlersForClosure returning false");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"invokeInboundHandlersForClosure Exit");
        }
        return true;
    }
}

