/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.XMLFaultCode;
import org.apache.axis2.jaxws.message.XMLFaultReason;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.factory.OMBlockFactory;
import org.apache.axis2.jaxws.message.factory.SAAJConverterFactory;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.message.util.SAAJConverter;
import org.apache.axis2.jaxws.registry.FactoryRegistry;

public class XMLFaultUtils {
    public static boolean isFault(javax.xml.soap.SOAPEnvelope envelope) throws SOAPException {
        javax.xml.soap.SOAPBody body = envelope.getBody();
        if (body != null) {
            return body.getFault() != null;
        }
        return false;
    }

    public static boolean isFault(SOAPEnvelope envelope) {
        return envelope.hasFault();
    }

    public static boolean containsFault(Block b) {
        QName qn;
        return b != null && (qn = b.getQName()) != null && qn.getLocalPart().equals("Fault") && (qn.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") || qn.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
    }

    public static XMLFault createXMLFault(SOAPFault soapFault, Block[] detailBlocks) throws WebServiceException {
        SOAPFaultRole soapRole;
        SOAPFaultNode soapNode;
        SOAPFaultSubCode soapSubCode;
        boolean isSoap11 = soapFault.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/");
        SOAPFaultCode soapCode = soapFault.getCode();
        QName codeQName = null;
        codeQName = isSoap11 ? soapCode.getTextAsQName() : soapCode.getValue().getTextAsQName();
        XMLFaultCode code = XMLFaultCode.fromQName(codeQName);
        SOAPFaultReason soapReason = soapFault.getReason();
        String text = null;
        String lang = null;
        List soapTexts = null;
        if (isSoap11) {
            text = soapReason.getText();
        } else {
            soapTexts = soapReason.getAllSoapTexts();
            SOAPFaultText reasonText = (SOAPFaultText)soapTexts.get(0);
            text = reasonText.getText();
            lang = reasonText.getLang();
        }
        XMLFaultReason reason = new XMLFaultReason(text, lang);
        XMLFault xmlFault = new XMLFault(code, reason, detailBlocks);
        if (soapSubCode != null) {
            ArrayList<QName> list = new ArrayList<QName>();
            for (soapSubCode = soapCode.getSubCode(); soapSubCode != null; soapSubCode = soapSubCode.getSubCode()) {
                SOAPFaultValue soapSubCodeValue = soapSubCode.getValue();
                QName qName = soapSubCodeValue.getTextAsQName();
                list.add(qName);
            }
            QName[] qNames = new QName[list.size()];
            xmlFault.setSubCodes(list.toArray(qNames));
        }
        if (soapTexts != null && soapTexts.size() > 1) {
            XMLFaultReason[] secondaryReasons = new XMLFaultReason[soapTexts.size() - 1];
            for (int i = 1; i < soapTexts.size(); ++i) {
                SOAPFaultText soapReasonText = (SOAPFaultText)soapTexts.get(i);
                secondaryReasons[i - 1] = new XMLFaultReason(soapReasonText.getText(), soapReasonText.getLang());
            }
            xmlFault.setSecondaryReasons(secondaryReasons);
        }
        if ((soapNode = soapFault.getNode()) != null) {
            xmlFault.setNode(soapNode.getText());
        }
        if ((soapRole = soapFault.getRole()) != null) {
            xmlFault.setRole(soapRole.getText());
        }
        return xmlFault;
    }

    public static XMLFault createXMLFault(javax.xml.soap.SOAPFault soapFault) throws WebServiceException {
        Block[] detailBlocks = XMLFaultUtils.getDetailBlocks(soapFault);
        return XMLFaultUtils.createXMLFault(soapFault, detailBlocks);
    }

    public static XMLFault createXMLFault(javax.xml.soap.SOAPFault soapFault, Block[] detailBlocks) throws WebServiceException {
        String soapRole;
        String soapNode;
        Iterator it;
        QName codeQName = soapFault.getFaultCodeAsQName();
        XMLFaultCode code = XMLFaultCode.fromQName(codeQName);
        String text = soapFault.getFaultString();
        Locale locale = soapFault.getFaultStringLocale();
        XMLFaultReason reason = new XMLFaultReason(text, XMLFaultUtils.localeToXmlLang(locale));
        XMLFault xmlFault = new XMLFault(code, reason, detailBlocks);
        boolean isSOAP12 = soapFault.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope");
        if (isSOAP12) {
            it = soapFault.getFaultSubcodes();
            ArrayList<QName> list = new ArrayList<QName>();
            while (it.hasNext()) {
                QName qName = (QName)it.next();
                list.add(qName);
            }
            if (list.size() > 0) {
                QName[] subCodes = new QName[list.size()];
                subCodes = list.toArray(subCodes);
                xmlFault.setSubCodes(subCodes);
            }
        }
        if (isSOAP12) {
            try {
                it = soapFault.getFaultReasonLocales();
                boolean first = true;
                ArrayList<XMLFaultReason> list = new ArrayList<XMLFaultReason>();
                while (it.hasNext()) {
                    locale = (Locale)it.next();
                    if (first) {
                        first = false;
                        continue;
                    }
                    text = soapFault.getFaultReasonText(locale);
                    list.add(new XMLFaultReason(text, XMLFaultUtils.localeToXmlLang(locale)));
                }
                if (list.size() > 0) {
                    XMLFaultReason[] secondaryReasons = new XMLFaultReason[list.size()];
                    secondaryReasons = list.toArray(secondaryReasons);
                    xmlFault.setSecondaryReasons(secondaryReasons);
                }
            }
            catch (SOAPException se) {
                throw ExceptionFactory.makeWebServiceException((Throwable)se);
            }
        }
        if (isSOAP12 && (soapNode = soapFault.getFaultNode()) != null) {
            xmlFault.setNode(soapNode);
        }
        if ((soapRole = soapFault.getFaultActor()) != null) {
            xmlFault.setRole(soapRole);
        }
        return xmlFault;
    }

    public static XMLFault createXMLFault(Block b, Protocol p) {
        Message m = null;
        try {
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            m = mf.create(p);
            m.setBodyBlock(b);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        SOAPEnvelope dummyEnv = (SOAPEnvelope)m.getAsOMElement();
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(dummyEnv.getXMLStreamReaderWithoutCaching());
        SOAPEnvelope newEnv = (SOAPEnvelope)builder.getDocumentElement();
        SOAPBody body = newEnv.getBody();
        SOAPFault fault = body.getFault();
        Block[] details = XMLFaultUtils.getDetailBlocks(fault);
        return XMLFaultUtils.createXMLFault(fault, details);
    }

    private static Block[] getDetailBlocks(SOAPFault soapFault) throws WebServiceException {
        try {
            Block[] blocks = null;
            SOAPFaultDetail detail = soapFault.getDetail();
            if (detail != null) {
                OMBlockFactory bf = (OMBlockFactory)FactoryRegistry.getFactory(OMBlockFactory.class);
                ArrayList<Block> list = new ArrayList<Block>();
                Iterator it = detail.getChildElements();
                while (it.hasNext()) {
                    OMElement om = (OMElement)it.next();
                    Block b = bf.createFrom(om, (Object)null, om.getQName());
                    list.add(b);
                }
                blocks = new Block[list.size()];
                blocks = list.toArray(blocks);
            }
            return blocks;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static Block[] getDetailBlocks(javax.xml.soap.SOAPFault soapFault) throws WebServiceException {
        try {
            Block[] blocks = null;
            Detail detail = soapFault.getDetail();
            if (detail != null) {
                SAAJConverterFactory converterFactory = (SAAJConverterFactory)FactoryRegistry.getFactory(SAAJConverterFactory.class);
                SAAJConverter converter = converterFactory.getSAAJConverter();
                OMBlockFactory bf = (OMBlockFactory)FactoryRegistry.getFactory(OMBlockFactory.class);
                ArrayList<Block> list = new ArrayList<Block>();
                Iterator it = detail.getChildElements();
                while (it.hasNext()) {
                    DetailEntry de = (DetailEntry)it.next();
                    OMElement om = converter.toOM((SOAPElement)de);
                    Block b = bf.createFrom(om, (Object)null, om.getQName());
                    list.add(b);
                }
                blocks = new Block[list.size()];
                blocks = list.toArray(blocks);
            }
            return blocks;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public static SOAPFault createSOAPFault(XMLFault xmlFault, SOAPBody body, boolean ignoreDetailBlocks) throws WebServiceException {
        XMLFaultReason[] reasons;
        QName[] subCodes;
        SOAPFactory factory = MessageUtils.getSOAPFactory((OMElement)body);
        SOAPFault soapFault = factory.createSOAPFault(body);
        OMNamespace ns = body.getNamespace();
        boolean isSoap11 = soapFault.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/");
        SOAPFaultCode soapCode = factory.createSOAPFaultCode(soapFault);
        QName soapValueQName = xmlFault.getCode().toQName(ns.getNamespaceURI());
        if (isSoap11) {
            soapCode.setText(soapValueQName);
        } else {
            SOAPFaultValue soapValue = factory.createSOAPFaultValue(soapCode);
            soapValue.setText(soapValueQName);
        }
        SOAPFaultReason soapReason = factory.createSOAPFaultReason(soapFault);
        if (isSoap11) {
            soapReason.setText(xmlFault.getReason().getText());
        } else {
            SOAPFaultText soapText = factory.createSOAPFaultText(soapReason);
            soapText.setText(xmlFault.getReason().getText());
            soapText.setLang(xmlFault.getReason().getLang());
        }
        Block[] blocks = xmlFault.getDetailBlocks();
        if (blocks != null && blocks.length > 0) {
            SOAPFaultDetail detail = factory.createSOAPFaultDetail(soapFault);
            if (!ignoreDetailBlocks) {
                for (int i = 0; i < blocks.length; ++i) {
                    OMSourcedElementImpl element = new OMSourcedElementImpl(blocks[i].getQName(), (OMFactory)factory, (OMDataSource)blocks[i]);
                    detail.addChild((OMNode)element);
                }
            }
        }
        if ((subCodes = xmlFault.getSubCodes()) != null && subCodes.length > 0) {
            SOAPFaultCode curr = soapCode;
            for (int i = 0; i < subCodes.length; ++i) {
                SOAPFaultSubCode subCode = i == 0 ? factory.createSOAPFaultSubCode(curr) : factory.createSOAPFaultSubCode((SOAPFaultSubCode)curr);
                SOAPFaultValue soapSubCodeValue = factory.createSOAPFaultValue(subCode);
                soapSubCodeValue.setText(subCodes[i]);
                curr = subCode;
            }
        }
        if ((reasons = xmlFault.getSecondaryReasons()) != null && reasons.length > 0) {
            for (int i = 0; i < reasons.length; ++i) {
                SOAPFaultText soapReasonText = factory.createSOAPFaultText(soapReason);
                soapReasonText.setText(reasons[i].getText());
                soapReasonText.setLang(reasons[i].getLang());
            }
        }
        if (xmlFault.getRole() != null) {
            SOAPFaultRole soapRole = factory.createSOAPFaultRole();
            soapRole.setText(xmlFault.getRole());
            soapFault.setRole(soapRole);
        }
        if (xmlFault.getNode() != null) {
            SOAPFaultNode soapNode = factory.createSOAPFaultNode();
            soapNode.setText(xmlFault.getNode());
            soapFault.setNode(soapNode);
        }
        return soapFault;
    }

    public static javax.xml.soap.SOAPFault createSAAJFault(XMLFault xmlFault, javax.xml.soap.SOAPBody body) throws SOAPException, WebServiceException {
        XMLFaultReason[] reasons;
        QName[] subCodes;
        String protocolNS = body.getNamespaceURI();
        javax.xml.soap.SOAPFault soapFault = body.addFault();
        QName soapValueQName = xmlFault.getCode().toQName(protocolNS);
        String prefix = soapFault.getPrefix();
        String soapValue = null;
        soapValue = prefix == null || prefix.length() == 0 ? soapValueQName.getLocalPart() : prefix + ":" + soapValueQName.getLocalPart();
        soapFault.setFaultCode(soapValue);
        String reasonText = xmlFault.getReason().getText();
        String reasonLang = xmlFault.getReason().getLang();
        Locale locale = reasonLang != null && reasonLang.length() > 0 ? new Locale(reasonLang) : Locale.getDefault();
        soapFault.setFaultString(reasonText, locale);
        Block[] blocks = xmlFault.getDetailBlocks();
        if (blocks != null && blocks.length > 0) {
            Detail detail = soapFault.addDetail();
            SAAJConverterFactory converterFactory = (SAAJConverterFactory)FactoryRegistry.getFactory(SAAJConverterFactory.class);
            SAAJConverter converter = converterFactory.getSAAJConverter();
            for (int i = 0; i < blocks.length; ++i) {
                try {
                    converter.toSAAJ(blocks[i].getOMElement(), (SOAPElement)detail);
                    continue;
                }
                catch (XMLStreamException xse) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)xse);
                }
            }
        }
        if ((subCodes = xmlFault.getSubCodes()) != null && subCodes.length > 0 && protocolNS.equals("http://www.w3.org/2003/05/soap-envelope")) {
            for (int i = 0; i < subCodes.length; ++i) {
                soapFault.appendFaultSubcode(subCodes[i]);
            }
        }
        if ((reasons = xmlFault.getSecondaryReasons()) != null && reasons.length > 0 && protocolNS.equals("http://www.w3.org/2003/05/soap-envelope")) {
            for (int i = 0; i < reasons.length; ++i) {
                locale = reasons[i].getLang() == null || reasons[i].getLang().length() == 0 ? Locale.getDefault() : new Locale(reasons[i].getLang());
                soapFault.addFaultReasonText(reasons[i].getText(), locale);
            }
        }
        if (xmlFault.getRole() != null) {
            soapFault.setFaultActor(xmlFault.getRole());
        }
        if (xmlFault.getNode() != null && protocolNS.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapFault.setFaultNode(xmlFault.getNode());
        }
        return soapFault;
    }

    private static String localeToXmlLang(Locale locale) {
        if (locale == null) {
            return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
        }
        String lang = locale.getLanguage();
        String countryCode = locale.getCountry();
        if (countryCode == null || countryCode.length() == 0) {
            return lang;
        }
        return new String(lang + "-" + countryCode);
    }
}

