/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws;

import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointReferenceUtils;
import org.apache.axis2.jaxws.binding.BindingUtils;
import org.apache.axis2.jaxws.binding.SOAPBinding;
import org.apache.axis2.jaxws.client.PropertyValidator;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.handler.HandlerResolverImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.spi.Binding;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BindingProvider
implements org.apache.axis2.jaxws.spi.BindingProvider {
    private static final Log log = LogFactory.getLog(BindingProvider.class);
    protected Map<String, Object> requestContext;
    protected Map<String, Object> responseContext;
    protected EndpointDescription endpointDesc;
    protected ServiceDelegate serviceDelegate;
    private Binding binding;
    public static final String BINDING_PROVIDER = "org.apache.axis2.jaxws.BindingProvider";

    public BindingProvider(ServiceDelegate svcDelegate, EndpointDescription epDesc, org.apache.axis2.addressing.EndpointReference epr, String addressingNamespace, WebServiceFeature ... features) {
        this.endpointDesc = epDesc;
        this.serviceDelegate = svcDelegate;
        this.initialize(epr, addressingNamespace, features);
    }

    private void initialize(org.apache.axis2.addressing.EndpointReference epr, String addressingNamespace, WebServiceFeature ... features) {
        String endpointAddress;
        this.requestContext = new ValidatingClientContext();
        this.responseContext = new ValidatingClientContext();
        this.requestContext.put("javax.xml.ws.session.maintain", Boolean.FALSE);
        this.requestContext.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        String addressingFlagFromWSDL = AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.endpointDesc.getAxisService());
        if ("unspecified".equals(addressingFlagFromWSDL)) {
            this.requestContext.put("disableAddressingForOutMessages", Boolean.TRUE);
        }
        String string = endpointAddress = epr != null ? epr.getAddress() : this.endpointDesc.getEndpointAddress();
        if (endpointAddress != null && !"".equals(endpointAddress)) {
            this.requestContext.put("javax.xml.ws.service.endpoint.address", endpointAddress);
        }
        this.binding = (Binding)BindingUtils.createBinding(this.endpointDesc);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Lookign for Handler Resolver");
        }
        HandlerResolver handlerResolver = null;
        if (this.serviceDelegate.getHandlerResolver() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Reading default Handler Resolver ");
            }
            handlerResolver = this.serviceDelegate.getHandlerResolver();
        } else {
            handlerResolver = new HandlerResolverImpl(this.endpointDesc.getServiceDescription(), (Object)this.serviceDelegate);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new Handler Resolver using HandlerResolverImpl");
            }
        }
        if (this.binding instanceof SOAPBinding) {
            this.configureBindingFromMetadata();
        }
        String seiName = null;
        if (this.endpointDesc.getEndpointInterfaceDescription() != null && this.endpointDesc.getEndpointInterfaceDescription().getSEIClass() != null) {
            seiName = this.endpointDesc.getEndpointInterfaceDescription().getSEIClass().getName();
        }
        String portQNameString = this.endpointDesc.getPortQName().toString();
        String key = seiName + ":" + portQNameString;
        Map bProps = this.endpointDesc.getServiceDescription().getBindingProperties((Object)this.serviceDelegate, key);
        if (bProps != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting binding props with size: " + bProps.size() + " on " + "BindingProvider RequestContext"));
            }
            this.requestContext.putAll(bProps);
        }
        this.binding.setHandlerChain(handlerResolver.getHandlerChain(this.endpointDesc.getPortInfo()));
        try {
            this.binding.setAxis2EndpointReference(epr);
            this.binding.setAddressingNamespace(addressingNamespace);
            this.binding.setFeatures(features);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private void configureBindingFromMetadata() {
        boolean enableMTOMFromMetadata = false;
        int mtomThreshold = 0;
        boolean isAddressingConfiguredViaMetadata = false;
        boolean enableRespectBindingdFromMetadata = false;
        boolean enableAddressingFromMetadata = false;
        boolean requireAddressingFromMetadata = false;
        AddressingFeature.Responses addressingResponses = null;
        if (this.endpointDesc.getEndpointInterfaceDescription() != null && this.endpointDesc.getEndpointInterfaceDescription().getSEIClass() != null) {
            enableMTOMFromMetadata = this.endpointDesc.getServiceDescription().isMTOMEnabled((Object)this.serviceDelegate, this.endpointDesc.getEndpointInterfaceDescription().getSEIClass());
            mtomThreshold = this.getMTOMThreshold(this.endpointDesc.getServiceDescription(), this.serviceDelegate, this.endpointDesc.getEndpointInterfaceDescription().getSEIClass());
            enableRespectBindingdFromMetadata = this.isRespectBindingEnabled(this.endpointDesc.getServiceDescription(), this.serviceDelegate, this.endpointDesc.getEndpointInterfaceDescription().getSEIClass());
            isAddressingConfiguredViaMetadata = this.isAddressingConfigured(this.endpointDesc.getServiceDescription(), this.serviceDelegate, this.endpointDesc.getEndpointInterfaceDescription().getSEIClass());
            if (isAddressingConfiguredViaMetadata) {
                enableAddressingFromMetadata = this.isAddressingEnabled(this.endpointDesc.getServiceDescription(), this.serviceDelegate, this.endpointDesc.getEndpointInterfaceDescription().getSEIClass());
                requireAddressingFromMetadata = this.isAddressingRequired(this.endpointDesc.getServiceDescription(), this.serviceDelegate, this.endpointDesc.getEndpointInterfaceDescription().getSEIClass());
                addressingResponses = this.getAddressingResponses(this.endpointDesc.getServiceDescription(), this.serviceDelegate, this.endpointDesc.getEndpointInterfaceDescription().getSEIClass());
            }
        } else {
            enableMTOMFromMetadata = this.endpointDesc.getServiceDescription().isMTOMEnabled((Object)this.serviceDelegate);
        }
        if (!enableMTOMFromMetadata) {
            String bindingType = this.endpointDesc.getClientBindingID();
            boolean bl = enableMTOMFromMetadata = bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        }
        if (enableMTOMFromMetadata) {
            ((SOAPBinding)this.binding).setMTOMEnabled(true);
            ((SOAPBinding)this.binding).setMTOMThreshold(mtomThreshold);
        }
        if (enableRespectBindingdFromMetadata) {
            ((SOAPBinding)this.binding).setRespectBindingEnabled(true);
        }
        if (isAddressingConfiguredViaMetadata) {
            ((SOAPBinding)this.binding).setAddressingConfigured(true);
            ((SOAPBinding)this.binding).setAddressingEnabled(enableAddressingFromMetadata);
            ((SOAPBinding)this.binding).setAddressingRequired(requireAddressingFromMetadata);
            ((SOAPBinding)this.binding).setAddressingResponses(addressingResponses);
        }
    }

    private boolean isRespectBindingEnabled(ServiceDescription serviceDescription, ServiceDelegate serviceDelegateKey, Class seiClass) {
        boolean isEnabled = serviceDescription.isRespectBindingEnabled((Object)serviceDelegateKey, seiClass);
        return isEnabled;
    }

    private boolean isAddressingConfigured(ServiceDescription serviceDescription, ServiceDelegate serviceDelegateKey, Class seiClass) {
        boolean isConfigured = serviceDescription.isAddressingConfigured((Object)serviceDelegateKey, seiClass);
        return isConfigured;
    }

    private boolean isAddressingEnabled(ServiceDescription serviceDescription, ServiceDelegate serviceDelegateKey, Class seiClass) {
        boolean isEnabled = serviceDescription.isAddressingEnabled((Object)serviceDelegateKey, seiClass);
        return isEnabled;
    }

    private boolean isAddressingRequired(ServiceDescription serviceDescription, ServiceDelegate serviceDelegateKey, Class seiClass) {
        boolean isRequired = serviceDescription.isAddressingRequired((Object)serviceDelegateKey, seiClass);
        return isRequired;
    }

    private AddressingFeature.Responses getAddressingResponses(ServiceDescription serviceDescription, ServiceDelegate serviceDelegateKey, Class seiClass) {
        AddressingFeature.Responses responses = serviceDescription.getAddressingResponses((Object)serviceDelegateKey, seiClass);
        return responses;
    }

    private int getMTOMThreshold(ServiceDescription serviceDescription, ServiceDelegate serviceDelegate, Class seiClass) {
        int threshold = serviceDescription.getMTOMThreshold((Object)serviceDelegate, seiClass);
        return threshold;
    }

    @Override
    public ServiceDelegate getServiceDelegate() {
        return this.serviceDelegate;
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.endpointDesc;
    }

    public javax.xml.ws.Binding getBinding() {
        return this.binding;
    }

    public Map<String, Object> getRequestContext() {
        return this.requestContext;
    }

    public Map<String, Object> getResponseContext() {
        return this.responseContext;
    }

    protected void checkMaintainSessionState(MessageContext mc, InvocationContext ic) {
        Map properties = ic.getServiceClient().getServiceContext().getProperties();
        boolean bValue = false;
        if (properties != null && properties.containsKey("javax.xml.ws.session.maintain")) {
            bValue = (Boolean)properties.get("javax.xml.ws.session.maintain");
        }
        if (mc.isMaintainSession() || bValue) {
            this.setupSessionContext(properties);
        }
    }

    protected void setupSessionContext(Map<String, Object> properties) {
        String sessionKey = null;
        Object sessionValue = null;
        if (properties == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NoMaintainSessionProperty"));
        }
        if (properties.containsKey("Location")) {
            sessionKey = "Location";
            sessionValue = properties.get(sessionKey);
            if (sessionValue != null && !"".equals(sessionValue)) {
                this.requestContext.put("javax.xml.ws.service.endpoint.address", sessionValue);
            }
        } else if (properties.containsKey("Cookie")) {
            sessionKey = "Cookie";
            sessionValue = properties.get(sessionKey);
            if (sessionValue != null && !"".equals(sessionValue)) {
                this.requestContext.put("Cookie", sessionValue);
            }
        } else if (properties.containsKey("Cookie2")) {
            sessionKey = "Cookie2";
            sessionValue = properties.get(sessionKey);
            if (sessionValue != null && !"".equals(sessionValue)) {
                this.requestContext.put("Cookie", sessionValue);
            }
        } else {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NoMaintainSessionProperty"));
        }
        if (sessionValue == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullValueForMaintainSessionProperty", (String)sessionKey));
        }
    }

    protected boolean useSoapAction() {
        Boolean use = (Boolean)this.requestContext.get("javax.xml.ws.soap.http.soapaction.use");
        if (use != null) {
            return use != false;
        }
        return true;
    }

    public EndpointReference getEndpointReference() {
        return this.getEndpointReference(W3CEndpointReference.class);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        EndpointReference jaxwsEPR = null;
        String addressingNamespace = EndpointReferenceUtils.getAddressingNamespace(clazz);
        try {
            org.apache.axis2.addressing.EndpointReference epr = this.binding.getAxis2EndpointReference();
            if (epr == null) {
                String address = (String)this.requestContext.get("javax.xml.ws.service.endpoint.address");
                if (address == null) {
                    address = this.endpointDesc.getEndpointAddress();
                }
                QName service = this.endpointDesc.getServiceQName();
                QName port = this.endpointDesc.getPortQName();
                String wsdlLocation = ((ServiceDescriptionWSDL)this.endpointDesc.getServiceDescription()).getWSDLLocation();
                epr = EndpointReferenceUtils.createAxis2EndpointReference(address, service, port, wsdlLocation, addressingNamespace);
            } else if (!addressingNamespace.equals(this.binding.getAddressingNamespace())) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"bindingProviderErr1", (String)this.binding.getAddressingNamespace(), (String)addressingNamespace));
            }
            jaxwsEPR = EndpointReferenceUtils.convertFromAxis2(epr, addressingNamespace);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"endpointRefConstructionFailure3", (String)e.toString()));
        }
        return (T)((EndpointReference)clazz.cast(jaxwsEPR));
    }

    class ValidatingClientContext
    extends Hashtable<String, Object> {
        private static final long serialVersionUID = 3485112205801917858L;

        ValidatingClientContext() {
        }

        @Override
        public synchronized Object put(String key, Object value) {
            if (value == null) {
                return null;
            }
            if (PropertyValidator.validate(key, value)) {
                return super.put(key, value);
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"invalidPropValue", (String)key, (String)value.getClass().getName(), (String)PropertyValidator.getExpectedValue(key).getName()));
        }
    }
}

