/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.async;

import java.security.PrivilegedAction;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.client.async.AsyncUtils;
import org.apache.axis2.jaxws.client.async.CallbackFutureTask;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.AsyncHandlerProxyFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallbackFuture
extends Callback {
    private static final Log log = LogFactory.getLog(CallbackFuture.class);
    private static final boolean debug = log.isDebugEnabled();
    private CallbackFutureTask cft;
    private Executor executor;
    private FutureTask task;
    private InvocationContext invocationCtx;

    public static String displayHandle(Object obj) {
        return obj.getClass().getName() + '@' + Integer.toHexString(obj.hashCode());
    }

    public CallbackFuture(InvocationContext ic, AsyncHandler handler) {
        final AsyncHandler handlerObj = handler;
        ClassLoader handlerCL = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return handlerObj.getClass().getClassLoader();
            }
        });
        AsyncHandler originalHandler = handler;
        try {
            if (debug) {
                log.debug((Object)("Calling factory to create proxy for AsyncHandler instance: " + CallbackFuture.displayHandle(handler)));
            }
            AsyncHandlerProxyFactory proxyFactory = (AsyncHandlerProxyFactory)FactoryRegistry.getFactory(AsyncHandlerProxyFactory.class);
            handler = proxyFactory.createAsyncHandlerProxy(handler);
            if (debug) {
                log.debug((Object)("Factory returned AsyncHandler proxy instance: " + CallbackFuture.displayHandle(handler)));
            }
        }
        catch (Exception e) {
            if (debug) {
                log.debug((Object)("AsyncHandlerProxyFactory threw an exception: " + e.toString()));
                e.printStackTrace();
            }
            handler = originalHandler;
        }
        this.cft = new CallbackFutureTask(ic.getAsyncResponseListener(), handler, handlerCL);
        this.task = new FutureTask(this.cft);
        this.executor = ic.getExecutor();
        this.invocationCtx = ic;
    }

    public Future<?> getFutureTask() {
        return this.task;
    }

    public void onComplete(AsyncResult result) {
        MessageContext response;
        block4: {
            if (debug) {
                log.debug((Object)"JAX-WS received the async response");
            }
            response = null;
            try {
                response = AsyncUtils.createJAXWSMessageContext(result);
                response.setInvocationContext(this.invocationCtx);
                response.setMEPContext(this.invocationCtx.getRequestMessageContext().getMEPContext());
            }
            catch (WebServiceException e) {
                this.cft.setError((Exception)((Object)e));
                if (!debug) break block4;
                log.debug((Object)("An error occured while processing the async response.  " + e.getMessage()));
            }
        }
        if (response == null) {
            // empty if block
        }
        this.cft.setMessageContext(response);
        this.execute();
    }

    public void onError(Exception e) {
        if (e.getClass().isAssignableFrom(AxisFault.class)) {
            AxisFault fault = (AxisFault)((Object)e);
            MessageContext faultMessageContext = null;
            try {
                faultMessageContext = AsyncUtils.createJAXWSMessageContext(fault.getFaultMessageContext());
                faultMessageContext.setInvocationContext(this.invocationCtx);
                faultMessageContext.setMEPContext(this.invocationCtx.getRequestMessageContext().getMEPContext());
            }
            catch (WebServiceException wse) {
                this.cft.setError((Exception)((Object)wse));
            }
            this.cft.setError(e);
            this.cft.setMessageContext(faultMessageContext);
        } else {
            this.cft.setError(e);
        }
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        block16: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executor task starting to process async response");
            }
            if (this.executor != null) {
                if (this.task != null && !this.task.isCancelled()) {
                    try {
                        this.executor.execute(this.task);
                    }
                    catch (Exception executorExc) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("CallbackFuture.execute():  executor exception [" + executorExc.getClass().getName() + "]"));
                        }
                        this.task.cancel(true);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Task submitted to Executor");
                    }
                    try {
                        CallbackFutureTask executorExc = this.cft;
                        synchronized (executorExc) {
                            if (!this.cft.done) {
                                this.cft.wait(180000L);
                            }
                            break block16;
                        }
                    }
                    catch (InterruptedException e) {
                        if (debug) {
                            log.debug((Object)"cft.wait() was interrupted");
                            log.debug((Object)("Exception: " + e.getMessage()));
                        }
                        break block16;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executor task was not sumbitted as Async Future task was cancelled by clients");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executor task completed");
        }
    }
}

