/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.impl;

import java.util.HashMap;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.databinding.DataSourceBlock;
import org.apache.axis2.jaxws.message.databinding.OMBlock;
import org.apache.axis2.jaxws.message.databinding.SOAPEnvelopeBlock;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.impl.MessageImpl;
import org.apache.axis2.util.WrappedDataHandler;

public class MessageFactoryImpl
implements MessageFactory {
    @Override
    public Message createFrom(XMLStreamReader reader, Protocol protocol) throws XMLStreamException, WebServiceException {
        Object builder = protocol == Protocol.rest ? new StAXOMBuilder(reader) : new StAXSOAPModelBuilder(reader, null);
        OMElement omElement = builder.getDocumentElement();
        return this.createFrom(omElement, protocol);
    }

    @Override
    public Message createFrom(OMElement omElement, Protocol protocol) throws XMLStreamException, WebServiceException {
        return new MessageImpl(omElement, protocol);
    }

    @Override
    public Message create(Protocol protocol) throws XMLStreamException, WebServiceException {
        return new MessageImpl(protocol);
    }

    @Override
    public Message createFrom(SOAPMessage message) throws XMLStreamException, WebServiceException {
        try {
            MessageImpl m = new MessageImpl(message.getSOAPPart().getEnvelope());
            MimeHeaders mimeHeaders = message.getMimeHeaders();
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                String key = mimeHeader.getName();
                String value = mimeHeader.getValue();
                if (key == null || value == null || "Content-Type".equalsIgnoreCase(key)) continue;
                map.put(key, value);
            }
            m.setMimeHeaders(map);
            if (message.countAttachments() > 0) {
                Iterator it = message.getAttachments();
                m.setDoingSWA(true);
                while (it.hasNext()) {
                    AttachmentPart ap = (AttachmentPart)it.next();
                    m.addDataHandler((DataHandler)new WrappedDataHandler(ap.getDataHandler(), ap.getContentType()), ap.getContentId());
                }
            }
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public Message createFrom(Block block, Object context, Protocol protocol) throws XMLStreamException, WebServiceException {
        if (block instanceof SOAPEnvelopeBlock) {
            return new MessageImpl((OMElement)((SOAPEnvelope)block.getBusinessObject(true)), protocol);
        }
        if (block instanceof DataSourceBlock) {
            return this.createFrom(block.getOMElement(), protocol);
        }
        if (block instanceof OMBlock) {
            OMBlock omblock = (OMBlock)block;
            return new MessageImpl((OMElement)omblock.getBusinessObject(true), protocol);
        }
        return this.createFrom(block.getXMLStreamReader(true), protocol);
    }
}

