/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.datasource.SourceDataSource;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.DataSourceBlock;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.message.util.Reader2Writer;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceBlockImpl
extends BlockImpl
implements DataSourceBlock {
    private static final Log log = LogFactory.getLog(DataSourceBlockImpl.class);

    DataSourceBlockImpl(DataSource busObject, QName qName, BlockFactory factory) throws WebServiceException {
        super(busObject, null, qName, factory);
        if (!(busObject instanceof DataSource)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceNotSupported", (String)busObject.getClass().getName()));
        }
    }

    public DataSourceBlockImpl(OMElement omElement, QName qName, BlockFactory factory) {
        super(omElement, (Object)null, qName, factory);
    }

    @Override
    protected Object _getBOFromReader(XMLStreamReader reader, Object busContext) throws XMLStreamException, WebServiceException {
        Reader2Writer r2w = new Reader2Writer(reader);
        try {
            return new ByteArrayDataSource(r2w.getAsString(), "application/octet-stream");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public OMElement getOMElement() throws XMLStreamException, WebServiceException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("", "");
        return factory.createOMElement((OMDataSource)this, "dummy", ns);
    }

    @Override
    protected Object _getBOFromOM(OMElement omElement, Object busContext) throws XMLStreamException, WebServiceException {
        OMDataSource busObject;
        OMDataSource ds;
        if (omElement instanceof OMSourcedElement && (ds = ((OMSourcedElement)omElement).getDataSource()) instanceof SourceDataSource) {
            return ((SourceDataSource)ds).getObject();
        }
        boolean hasFault = false;
        if (this.parent != null && this.parent.isFault() || omElement.getQName().getLocalPart().equals("Fault")) {
            hasFault = true;
        }
        if (!hasFault) {
            busObject = ((OMSourcedElement)omElement).getDataSource();
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            omElement.serialize((OutputStream)baos);
            busObject = new ByteArrayDataSource(baos.toByteArray(), "UTF-8");
        }
        return busObject;
    }

    @Override
    protected XMLStreamReader _getReaderFromBO(Object busObj, Object busContext) throws XMLStreamException, WebServiceException {
        try {
            if (busObj instanceof DataSource) {
                XMLInputFactory f = StAXUtils.getXMLInputFactory();
                XMLStreamReader reader = f.createXMLStreamReader(((DataSource)busObj).getInputStream());
                StAXUtils.releaseXMLInputFactory((XMLInputFactory)f);
                return reader;
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceNotSupported", (String)this.busObject.getClass().getName()));
        }
        catch (Exception e) {
            String className = busObj == null ? "none" : busObj.getClass().getName();
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceReadErr", (String)className), (Throwable)e);
        }
    }

    @Override
    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            BufferUtils.inputStream2OutputStream((InputStream)((DataSource)this.busObject).getInputStream(), (OutputStream)output);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    protected void _outputFromBO(Object busObject, Object busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start _outputFromBO");
        }
        XMLStreamReader reader = this._getReaderFromBO(busObject, busContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Obtained reader=" + reader));
        }
        this._outputFromReader(reader, writer);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End _outputReaderFromBO");
        }
    }

    @Override
    protected Object _getBOFromBO(Object busObject, Object busContext, boolean consume) {
        if (consume) {
            return busObject;
        }
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceMissingSupport", (String)busObject.getClass().getName()));
    }

    @Override
    public boolean isElementData() {
        return false;
    }

    private static Class forName(final String className) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    public void close() {
    }

    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        try {
            byte[] bytes = (byte[])ConvertUtils.convert(this.getBusinessObject(false), byte[].class);
            return new ByteArrayInputStream(bytes);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Object getObject() {
        try {
            return this.getBusinessObject(false);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public boolean isDestructiveRead() {
        return true;
    }

    public boolean isDestructiveWrite() {
        return true;
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start getXMLBytes");
        }
        byte[] bytes = null;
        try {
            bytes = (byte[])ConvertUtils.convert(this.getBusinessObject(false), byte[].class);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End getXMLBytes");
        }
        return bytes;
    }
}

