/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.databinding.SOAPEnvelopeBlock;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.message.util.SOAPElementReader;
import org.apache.axis2.jaxws.registry.FactoryRegistry;

public class SOAPEnvelopeBlockImpl
extends BlockImpl
implements SOAPEnvelopeBlock {
    public SOAPEnvelopeBlockImpl(Object busObject, Object busContext, QName qName, BlockFactory factory) {
        super(busObject, busContext, qName == null ? SOAPEnvelopeBlockImpl.getQName((SOAPEnvelope)busObject) : qName, factory);
    }

    public SOAPEnvelopeBlockImpl(OMElement omElement, Object busContext, QName qName, BlockFactory factory) {
        super(omElement, busContext, qName, factory);
    }

    @Override
    protected Object _getBOFromReader(XMLStreamReader reader, Object busContext) throws XMLStreamException, WebServiceException {
        MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
        Message message = mf.createFrom(reader, null);
        SOAPEnvelope env = message.getAsSOAPEnvelope();
        this.setQName(SOAPEnvelopeBlockImpl.getQName(env));
        return env;
    }

    @Override
    protected XMLStreamReader _getReaderFromBO(Object busObj, Object busContext) throws XMLStreamException, WebServiceException {
        return new SOAPElementReader((SOAPElement)busObj);
    }

    @Override
    protected void _outputFromBO(Object busObject, Object busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        XMLStreamReader reader = this._getReaderFromBO(busObject, busContext);
        this._outputFromReader(reader, writer);
    }

    private static QName getQName(SOAPEnvelope env) {
        return new QName(env.getNamespaceURI(), env.getLocalName(), env.getPrefix());
    }

    @Override
    public boolean isElementData() {
        return true;
    }

    public void close() {
    }

    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        byte[] bytes = this.getXMLBytes(encoding);
        return new ByteArrayInputStream(bytes);
    }

    public Object getObject() {
        try {
            return this.getBusinessObject(false);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OMOutputFormat format = new OMOutputFormat();
        format.setCharSetEncoding(encoding);
        try {
            this.serialize(baos, format);
            baos.flush();
            return baos.toByteArray();
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }
}

