/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.axis2.util.JavaUtils;

public class XFormURLEncodedFormatter
implements MessageFormatter {
    @Override
    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        OMElement omElement = messageContext.getEnvelope().getBody().getFirstElement();
        if (omElement != null) {
            Iterator it = omElement.getChildElements();
            String paraString = "";
            String encoding = format.getCharSetEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            while (it.hasNext()) {
                String parameter;
                OMElement ele1 = (OMElement)it.next();
                try {
                    parameter = ele1.getLocalName() + "=" + URLEncoder.encode(ele1.getText(), encoding).replace("+", "%20");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("UnsupportedEncoding for " + ele1.getText());
                }
                paraString = "".equals(paraString) ? parameter : paraString + "&" + parameter;
            }
            return paraString.getBytes();
        }
        return new byte[0];
    }

    @Override
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        try {
            outputStream.write(this.getBytes(messageContext, format));
        }
        catch (IOException e) {
            throw new AxisFault("An error occured while writing the request");
        }
    }

    @Override
    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String encoding = format.getCharSetEncoding();
        String contentType = "application/x-www-form-urlencoded";
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (soapAction != null && !"".equals(soapAction.trim()) && !"\"\"".equals(soapAction.trim())) {
            contentType = contentType + ";action=\"" + soapAction + "\";";
        }
        return contentType;
    }

    @Override
    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, messageContext, true);
        String ignoreUncited = (String)messageContext.getProperty("whttp:ignoreUncited");
        if (ignoreUncited == null || !JavaUtils.isTrueExplicitly(ignoreUncited)) {
            String httpMethod = (String)messageContext.getProperty("HTTP_METHOD");
            if ("GET".equals(httpMethod) || "DELETE".equals(httpMethod)) {
                targetURL = URLTemplatingUtil.appendQueryParameters(messageContext, targetURL);
            }
        } else {
            messageContext.getEnvelope().getBody().getFirstElement().detach();
        }
        return targetURL;
    }

    @Override
    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }
}

