/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.ping;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.Pingable;
import org.apache.axis2.ping.PingConstants;
import org.apache.axis2.ping.PingResponse;
import org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingMessageReceiver
extends AbstractInOutSyncMessageReceiver
implements PingConstants {
    private static Log log = LogFactory.getLog((Class)PingMessageReceiver.class);

    public void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        try {
            PingResponse pingResponse = new PingResponse();
            pingResponse.initPingResponse(inMessage);
            Iterator opListIterator = this.getAxisOperations(inMessage);
            while (opListIterator.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)opListIterator.next();
                if ("ping".equals(axisOperation.getName().getLocalPart())) continue;
                int operationStatus = this.invokePingableMR(inMessage, axisOperation);
                pingResponse.addOperationStatus(axisOperation, operationStatus);
            }
            SOAPEnvelope envelope = pingResponse.getResposeEnvelope();
            outMessage.setEnvelope(envelope);
        }
        catch (Exception e) {
            String msg = "Exception occurred while trying to ping the service" + inMessage.getAxisService().getName();
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
    }

    private Iterator getAxisOperations(MessageContext inMessage) throws AxisFault {
        Iterator operationsIterator;
        boolean serviceLevel = false;
        OMElement element = null;
        OMElement pingRequestElement = inMessage.getEnvelope().getBody().getFirstChildWithName(new QName("pingRequest"));
        if (pingRequestElement == null) {
            serviceLevel = true;
        } else {
            element = pingRequestElement.getFirstChildWithName(new QName("operation"));
        }
        if (!serviceLevel && element != null) {
            Iterator elementIterator = pingRequestElement.getChildrenWithName(new QName("operation"));
            ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
            while (elementIterator.hasNext()) {
                OMElement opElement = (OMElement)elementIterator.next();
                String operationName = opElement.getText();
                AxisOperation axisOperation = inMessage.getAxisService().getOperation(new QName(operationName));
                if (axisOperation != null) {
                    operationList.add(axisOperation);
                    continue;
                }
                String msg = "Operation not found: " + operationName + " specified in the ping request for the service" + inMessage.getAxisService().getName();
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            operationsIterator = operationList.iterator();
        } else {
            operationsIterator = inMessage.getAxisService().getOperations();
        }
        return operationsIterator;
    }

    private int invokePingableMR(MessageContext inMessage, AxisOperation axisOperation) throws AxisFault {
        MessageReceiver msgReceiver = axisOperation.getMessageReceiver();
        if (msgReceiver != null && msgReceiver instanceof Pingable) {
            Pingable pingableMR = (Pingable)msgReceiver;
            inMessage.setProperty("operationToPing", (Object)axisOperation.getName().getLocalPart());
            return pingableMR.ping();
        }
        return 1;
    }
}

