/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.ping;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.ping.PingConstants;

public class PingResponse
implements PingConstants {
    private OMElement pingResponse;
    private SOAPFactory soapFactory;
    private OMNamespace pingNamespace;

    public void initPingResponse(MessageContext msgContext) {
        this.soapFactory = msgContext.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        OMElement pingRequestElement = msgContext.getEnvelope().getBody().getFirstChildWithName(new QName("pingRequest"));
        this.pingNamespace = pingRequestElement != null ? pingRequestElement.getNamespace() : this.soapFactory.createOMNamespace("http://ws.apache.org/axis2/modules/ping/xsd", "");
        this.pingResponse = this.soapFactory.createOMElement("pingResponse", this.pingNamespace);
    }

    public void addOperationStatus(String operationName, int opStatus) {
        OMElement status = this.soapFactory.createOMElement("status", this.pingNamespace);
        status.addChild((OMNode)this.soapFactory.createOMText(Integer.toString(opStatus)));
        OMElement operation = this.soapFactory.createOMElement("operationStatus", this.pingNamespace);
        operation.addAttribute("name", operationName, this.pingNamespace);
        operation.addChild((OMNode)status);
        this.pingResponse.addChild((OMNode)operation);
    }

    public void addOperationStatus(AxisOperation axisOperation, int opStatus) {
        this.addOperationStatus(axisOperation.getName().getLocalPart(), opStatus);
    }

    public SOAPEnvelope getResposeEnvelope() {
        SOAPEnvelope envelope = this.soapFactory.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)this.pingResponse);
        return envelope;
    }
}

