/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.repo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;

public class ArchiveDeployer {
    private final File directory;
    private final String fileListName;
    private final boolean generateFileList;
    private final boolean stripVersion;
    private final List<String> files = new ArrayList<String>();

    public ArchiveDeployer(File repositoryDirectory, String directory, String fileListName, boolean generateFileList, boolean stripVersion) {
        this.directory = new File(repositoryDirectory, directory);
        this.fileListName = fileListName;
        this.generateFileList = generateFileList;
        this.stripVersion = stripVersion;
    }

    public void deploy(Log log, Artifact artifact) throws MojoExecutionException {
        StringBuilder buffer = new StringBuilder(artifact.getArtifactId());
        if (!this.stripVersion) {
            buffer.append("-");
            buffer.append(artifact.getVersion());
        }
        buffer.append(".");
        buffer.append(artifact.getType());
        String destFileName = buffer.toString();
        log.info((CharSequence)("Adding " + destFileName));
        try {
            FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.directory, destFileName));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error copying " + destFileName + ": " + ex.getMessage(), (Exception)ex);
        }
        this.files.add(destFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Log log) throws MojoExecutionException {
        if (this.generateFileList && !this.files.isEmpty()) {
            log.info((CharSequence)("Writing " + this.fileListName));
            try {
                FileOutputStream out = new FileOutputStream(new File(this.directory, this.fileListName));
                try {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                    for (String file : this.files) {
                        writer.write(file);
                        ((Writer)writer).write(10);
                    }
                    ((Writer)writer).flush();
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error writing " + this.fileListName + ": " + ex.getMessage(), (Exception)ex);
            }
        }
    }
}

