/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.builders;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.SecureConversationToken;

public class SecureConversationTokenBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SecureConversationToken conversationToken = new SecureConversationToken();
        OMAttribute attribute = element.getAttribute(Constants.INCLUDE_TOKEN);
        if (attribute == null) {
            throw new IllegalArgumentException("SecurityContextToken doesn't contain any sp:IncludeToken attribute");
        }
        String inclusionValue = attribute.getAttributeValue().trim();
        if (inclusionValue.endsWith("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Never")) {
            conversationToken.setInclusion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Never");
        } else if (inclusionValue.endsWith("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once")) {
            conversationToken.setInclusion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once");
        } else if (inclusionValue.endsWith("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient")) {
            conversationToken.setInclusion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient");
        } else if (inclusionValue.endsWith("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always")) {
            conversationToken.setInclusion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always");
        }
        OMElement issuer = element.getFirstChildWithName(Constants.ISSUER);
        if (issuer != null) {
            conversationToken.setIssuerEpr(issuer.getFirstElement());
        }
        if ((element = element.getFirstChildWithName(Constants.POLICY)) != null) {
            OMElement bootstrapPolicyElement;
            if (element.getFirstChildWithName(Constants.REQUIRE_DERIVED_KEYS) != null) {
                conversationToken.setDerivedKeys(true);
            }
            if (element.getFirstChildWithName(Constants.REQUIRE_EXTERNAL_URI_REFERNCE) != null) {
                conversationToken.setRequireExternalUriRef(true);
            }
            if (element.getFirstChildWithName(Constants.SC10_SECURITY_CONTEXT_TOKEN) != null) {
                conversationToken.setSc10SecurityContextToken(true);
            }
            if ((bootstrapPolicyElement = element.getFirstChildWithName(Constants.BOOTSTRAP_POLICY)) != null) {
                Policy policy = PolicyEngine.getPolicy((OMElement)bootstrapPolicyElement.getFirstElement());
                conversationToken.setBootstrapPolicy(policy);
            }
        }
        return conversationToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{Constants.SECURE_CONVERSATION_TOKEN};
    }
}

