/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.builders;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.SecurityContextToken;

public class SecurityContextTokenBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SecurityContextToken contextToken = new SecurityContextToken();
        OMAttribute attribute = element.getAttribute(Constants.INCLUDE_TOKEN);
        if (attribute == null) {
            throw new IllegalArgumentException("SecurityContextToken doesn't contain any sp:IncludeToken attribute");
        }
        String inclusionValue = attribute.getAttributeValue().trim();
        if (inclusionValue.endsWith("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Never")) {
            contextToken.setInclusion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Never");
        } else if (inclusionValue.endsWith("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once")) {
            contextToken.setInclusion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once");
        } else if (inclusionValue.endsWith("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient")) {
            contextToken.setInclusion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient");
        } else if (inclusionValue.endsWith("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always")) {
            contextToken.setInclusion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always");
        }
        element = element.getFirstChildWithName(Constants.POLICY);
        if (element != null) {
            if (element.getFirstChildWithName(Constants.REQUIRE_DERIVED_KEYS) != null) {
                contextToken.setDerivedKeys(true);
            }
            if (element.getFirstChildWithName(Constants.REQUIRE_EXTERNAL_URI_REFERNCE) != null) {
                contextToken.setRequireExternalUriRef(true);
            }
            if (element.getFirstChildWithName(Constants.SC10_SECURITY_CONTEXT_TOKEN) != null) {
                contextToken.setSc10SecurityContextToken(true);
            }
        }
        return contextToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{Constants.SECURE_CONVERSATION_TOKEN};
    }
}

