/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class EncryptionToken
extends AbstractSecurityAssertion
implements TokenWrapper {
    private Token encryptionToken;

    public Token getEncryptionToken() {
        return this.encryptionToken;
    }

    public void setEncryptionToken(Token encryptionToken) {
        this.encryptionToken = encryptionToken;
    }

    public void setToken(Token tok) {
        this.setEncryptionToken(tok);
    }

    public QName getName() {
        return Constants.ENCRYPTION_TOKEN;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String wspNamespaceURI;
        String wspWriterPrefix;
        String prefix;
        String localname = Constants.ENCRYPTION_TOKEN.getLocalPart();
        String namespaceURI = Constants.ENCRYPTION_TOKEN.getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = Constants.ENCRYPTION_TOKEN.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((wspWriterPrefix = writer.getPrefix(wspNamespaceURI = Constants.POLICY.getNamespaceURI())) == null) {
            wspPrefix = Constants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, wspNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        writer.writeStartElement(wspPrefix, Constants.POLICY.getLocalPart(), wspNamespaceURI);
        if (wspWriterPrefix == null) {
            writer.writeNamespace(wspPrefix, wspNamespaceURI);
        }
        if (this.encryptionToken == null) {
            throw new RuntimeException("EncryptionToken is not set");
        }
        this.encryptionToken.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

