/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Policy;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.SecurityContextToken;

public class SecureConversationToken
extends SecurityContextToken {
    private Policy bootstrapPolicy;
    private OMElement issuerEpr;

    public Policy getBootstrapPolicy() {
        return this.bootstrapPolicy;
    }

    public void setBootstrapPolicy(Policy bootstrapPolicy) {
        this.bootstrapPolicy = bootstrapPolicy;
    }

    public QName getName() {
        return Constants.SECURE_CONVERSATION_TOKEN;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String inclusion;
        String prefix;
        String localname = Constants.SECURE_CONVERSATION_TOKEN.getLocalPart();
        String namespaceURI = Constants.SECURE_CONVERSATION_TOKEN.getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = Constants.SECURE_CONVERSATION_TOKEN.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((inclusion = this.getInclusion()) != null) {
            writer.writeAttribute(prefix, namespaceURI, Constants.INCLUDE_TOKEN.getLocalPart(), inclusion);
        }
        if (this.issuerEpr != null) {
            writer.writeStartElement(prefix, Constants.ISSUER.getLocalPart(), namespaceURI);
            this.issuerEpr.serialize(writer);
            writer.writeEndElement();
        }
        if (this.isDerivedKeys() || this.isRequireExternalUriRef() || this.isSc10SecurityContextToken() || this.bootstrapPolicy != null) {
            String wspPrefix;
            String wspNamespaceURI = Constants.POLICY.getNamespaceURI();
            String wspWriterPrefix = writer.getPrefix(wspNamespaceURI);
            if (wspWriterPrefix == null) {
                wspPrefix = Constants.POLICY.getPrefix();
                writer.setPrefix(wspPrefix, wspNamespaceURI);
            } else {
                wspPrefix = wspWriterPrefix;
            }
            writer.writeStartElement(wspPrefix, Constants.POLICY.getLocalPart(), wspNamespaceURI);
            if (wspWriterPrefix == null) {
                writer.writeNamespace(wspPrefix, wspNamespaceURI);
            }
            if (this.isDerivedKeys()) {
                writer.writeEmptyElement(prefix, Constants.REQUIRE_DERIVED_KEYS.getLocalPart(), wspWriterPrefix);
            }
            if (this.isRequireExternalUriRef()) {
                writer.writeEmptyElement(prefix, Constants.REQUIRE_EXTERNAL_URI_REFERNCE.getLocalPart(), namespaceURI);
            }
            if (this.isSc10SecurityContextToken()) {
                writer.writeEmptyElement(prefix, Constants.SC10_SECURITY_CONTEXT_TOKEN.getLocalPart(), namespaceURI);
            }
            if (this.bootstrapPolicy != null) {
                writer.writeStartElement(prefix, Constants.BOOTSTRAP_POLICY.getLocalPart(), namespaceURI);
                this.bootstrapPolicy.serialize(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public OMElement getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(OMElement issuerEpr) {
        this.issuerEpr = issuerEpr;
    }
}

