/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Header;

public class SignedEncryptedParts
extends AbstractSecurityAssertion {
    private boolean body;
    private ArrayList headers = new ArrayList();
    private boolean signedParts;

    public SignedEncryptedParts(boolean signedParts) {
        this.signedParts = signedParts;
    }

    public boolean isBody() {
        return this.body;
    }

    public void setBody(boolean body) {
        this.body = body;
    }

    public ArrayList getHeaders() {
        return this.headers;
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public boolean isSignedParts() {
        return this.signedParts;
    }

    public QName getName() {
        if (this.signedParts) {
            return Constants.SIGNED_PARTS;
        }
        return Constants.ENCRYPTED_PARTS;
    }

    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        if (this.isBody()) {
            writer.writeStartElement(prefix, "Body", namespaceURI);
            writer.writeEndElement();
        }
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            writer.writeStartElement(prefix, "Header", namespaceURI);
            writer.writeAttribute("Name", header.getName());
            writer.writeAttribute("Namespace", header.getNamespace());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

