/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.AlgorithmWrapper;
import org.apache.ws.secpolicy.model.SignedEncryptedElements;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class SupportingToken
extends AbstractSecurityAssertion
implements AlgorithmWrapper,
TokenWrapper {
    private int type;
    private AlgorithmSuite algorithmSuite;
    private ArrayList tokens = new ArrayList();
    private SignedEncryptedElements signedElements;
    private SignedEncryptedElements encryptedElements;
    private SignedEncryptedParts signedParts;
    private SignedEncryptedParts encryptedParts;

    public SupportingToken(int type) {
        this.type = type;
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    public void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public ArrayList getTokens() {
        return this.tokens;
    }

    public void addToken(Token token) {
        this.tokens.add(token);
    }

    public int getTokenType() {
        return this.type;
    }

    public void setTokenType(int type) {
        this.type = type;
    }

    public SignedEncryptedElements getEncryptedElements() {
        return this.encryptedElements;
    }

    public void setEncryptedElements(SignedEncryptedElements encryptedElements) {
        this.encryptedElements = encryptedElements;
    }

    public SignedEncryptedParts getEncryptedParts() {
        return this.encryptedParts;
    }

    public void setEncryptedParts(SignedEncryptedParts encryptedParts) {
        this.encryptedParts = encryptedParts;
    }

    public SignedEncryptedElements getSignedElements() {
        return this.signedElements;
    }

    public void setSignedElements(SignedEncryptedElements signedElements) {
        this.signedElements = signedElements;
    }

    public SignedEncryptedParts getSignedParts() {
        return this.signedParts;
    }

    public void setSignedParts(SignedEncryptedParts signedParts) {
        this.signedParts = signedParts;
    }

    public void setToken(Token tok) {
        this.addToken(tok);
    }

    public QName getName() {
        switch (this.type) {
            case 1: {
                return Constants.SUPPORIING_TOKENS;
            }
            case 3: {
                return Constants.SIGNED_SUPPORTING_TOKENS;
            }
            case 2: {
                return Constants.ENDORSING_SUPPORTING_TOKENS;
            }
            case 4: {
                return Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS;
            }
        }
        return null;
    }

    public PolicyComponent normalize() {
        return this;
    }

    public short getType() {
        return 5;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String namespaceURI = Constants.SUPPORIING_TOKENS.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = Constants.SUPPORIING_TOKENS.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        String localname = null;
        switch (this.getTokenType()) {
            case 1: {
                localname = Constants.SUPPORIING_TOKENS.getLocalPart();
                break;
            }
            case 3: {
                localname = Constants.SIGNED_SUPPORTING_TOKENS.getLocalPart();
                break;
            }
            case 2: {
                localname = Constants.ENDORSING_SUPPORTING_TOKENS.getLocalPart();
                break;
            }
            case 4: {
                localname = Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS.getLocalPart();
                break;
            }
            default: {
                throw new RuntimeException("Invalid SupportingTokenType");
            }
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(Constants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = Constants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, Constants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, Constants.POLICY.getLocalPart(), Constants.POLICY.getNamespaceURI());
        Iterator iterator = this.getTokens().iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            token.serialize(writer);
        }
        if (this.signedParts != null) {
            this.signedElements.serialize(writer);
        } else if (this.signedElements != null) {
            this.signedElements.serialize(writer);
        } else if (this.encryptedParts != null) {
            this.encryptedParts.serialize(writer);
        } else if (this.encryptedElements != null) {
            this.encryptedElements.serialize(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

