/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.Token;

public class X509Token
extends Token {
    private boolean requireKeyIdentifierReference;
    private boolean requireIssuerSerialReference;
    private boolean requireEmbeddedTokenReference;
    private boolean requireThumbprintReference;
    private String tokenVersionAndType;

    public boolean isRequireEmbeddedTokenReference() {
        return this.requireEmbeddedTokenReference;
    }

    public void setRequireEmbeddedTokenReference(boolean requireEmbeddedTokenReference) {
        this.requireEmbeddedTokenReference = requireEmbeddedTokenReference;
    }

    public boolean isRequireIssuerSerialReference() {
        return this.requireIssuerSerialReference;
    }

    public void setRequireIssuerSerialReference(boolean requireIssuerSerialReference) {
        this.requireIssuerSerialReference = requireIssuerSerialReference;
    }

    public boolean isRequireKeyIdentifierReference() {
        return this.requireKeyIdentifierReference;
    }

    public void setRequireKeyIdentifierReference(boolean requireKeyIdentifierReference) {
        this.requireKeyIdentifierReference = requireKeyIdentifierReference;
    }

    public boolean isRequireThumbprintReference() {
        return this.requireThumbprintReference;
    }

    public void setRequireThumbprintReference(boolean requireThumbprintReference) {
        this.requireThumbprintReference = requireThumbprintReference;
    }

    public String getTokenVersionAndType() {
        return this.tokenVersionAndType;
    }

    public void setTokenVersionAndType(String tokenVersionAndType) {
        this.tokenVersionAndType = tokenVersionAndType;
    }

    public QName getName() {
        return Constants.X509_TOKEN;
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String pPrefix;
        String localName = Constants.X509_TOKEN.getLocalPart();
        String namespaceURI = Constants.X509_TOKEN.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = Constants.X509_TOKEN.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        String inclusion = this.getInclusion();
        if (inclusion != null) {
            writer.writeAttribute(prefix, namespaceURI, Constants.INCLUDE_TOKEN.getLocalPart(), inclusion);
        }
        if ((pPrefix = writer.getPrefix(Constants.POLICY.getNamespaceURI())) == null) {
            pPrefix = Constants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, Constants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, Constants.POLICY.getLocalPart(), Constants.POLICY.getNamespaceURI());
        if (this.isRequireKeyIdentifierReference()) {
            writer.writeStartElement(prefix, Constants.REQUIRE_KEY_IDENTIFIRE_REFERENCE.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireIssuerSerialReference()) {
            writer.writeStartElement(prefix, Constants.REQUIRE_ISSUER_SERIAL_REFERENCE.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireEmbeddedTokenReference()) {
            writer.writeStartElement(prefix, Constants.REQUIRE_EMBEDDED_TOKEN_REFERENCE.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireThumbprintReference()) {
            writer.writeStartElement(prefix, Constants.REQUIRE_THUMBPRINT_REFERENCE.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.tokenVersionAndType != null) {
            writer.writeStartElement(prefix, this.tokenVersionAndType, namespaceURI);
            writer.writeEndElement();
        }
        if (this.isDerivedKeys()) {
            writer.writeStartElement(prefix, Constants.REQUIRE_DERIVED_KEYS.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

