/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.testutils;

import java.io.File;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.http.SimpleHTTPServer;

public class UtilServer {
    private static SimpleHTTPServer receiver;

    public static synchronized void deployService(AxisService service) throws AxisFault {
        receiver.getConfigurationContext().getAxisConfiguration().addService(service);
    }

    public static synchronized void unDeployService(QName service) throws AxisFault {
        receiver.getConfigurationContext().getAxisConfiguration().removeService(service.getLocalPart());
    }

    public static synchronized void start(int testingPort, String repository) throws Exception {
        UtilServer.start(testingPort, repository, null);
    }

    public static synchronized void start(int testingPort, String repository, String axis2xml) throws Exception {
        if (receiver != null) {
            System.out.println("Server already started !!");
            throw new IllegalStateException("Server already started");
        }
        ConfigurationContext er = UtilServer.getNewConfigurationContext(repository, axis2xml);
        receiver = new SimpleHTTPServer(er, testingPort);
        try {
            receiver.start();
        }
        catch (AxisFault e) {
            System.out.println("Error occurred starting the server. " + e.getMessage());
            throw e;
        }
        System.out.print("Server started on port " + testingPort + ".....");
    }

    public static ConfigurationContext getNewConfigurationContext(String repository, String axis2xml) throws Exception {
        File file = new File(repository);
        if (!file.exists()) {
            throw new Exception("repository directory " + file.getAbsolutePath() + " does not exists");
        }
        if (axis2xml == null) {
            axis2xml = file.getAbsolutePath() + "/conf/axis2.xml";
        }
        return ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)file.getAbsolutePath(), (String)axis2xml);
    }

    public static synchronized void stop() throws AxisFault {
        if (receiver == null) {
            throw new IllegalStateException("Server not started");
        }
        receiver.stop();
        UtilServer.waitUntilStopped();
        System.out.print("Server stopped .....");
        ListenerManager listenerManager = receiver.getConfigurationContext().getListenerManager();
        if (listenerManager != null) {
            listenerManager.stop();
        }
        receiver = null;
    }

    public static ConfigurationContext getConfigurationContext() {
        return receiver.getConfigurationContext();
    }

    public static boolean waitUntilStopped() {
        System.out.println("Waiting until receiver stopped ..");
        while (receiver != null && receiver.isRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }
}

