/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.threads;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeWorkerPool
implements WorkerPool {
    static final Log log = LogFactory.getLog(NativeWorkerPool.class);
    private final ThreadPoolExecutor executor;
    private final LinkedBlockingQueue<Runnable> blockingQueue;

    public NativeWorkerPool(int core, int max, int keepAlive, int queueLength, String threadGroupName, String threadGroupId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Using native util.concurrent package..");
        }
        this.blockingQueue = queueLength == -1 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(queueLength);
        this.executor = new ThreadPoolExecutor(core, max, (long)keepAlive, TimeUnit.SECONDS, this.blockingQueue, new NativeThreadFactory(new ThreadGroup(threadGroupName), threadGroupId));
    }

    public void execute(final Runnable task) {
        this.executor.execute(new Runnable(){

            public void run() {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    log.error((Object)"Uncaught exception", t);
                }
            }
        });
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public int getQueueSize() {
        return this.blockingQueue.size();
    }

    public void shutdown(int timeout) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
    }
}

