/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.sms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.sms.InvalidMessageFormatException;
import org.apache.axis2.transport.sms.SMSMessage;
import org.apache.axis2.transport.sms.SMSMessageBuilder;
import org.apache.axis2.transport.sms.SMSTransportConstents;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroupBase;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

public class DefaultSMSMessageBuilderImpl
implements SMSMessageBuilder {
    public static final String KEY_VALUE_SEPERATOR = "=";
    protected Log log = LogFactory.getLog(this.getClass());

    public MessageContext buildMessaage(SMSMessage msg, ConfigurationContext configurationContext) throws InvalidMessageFormatException {
        String message = msg.getContent();
        String sender = msg.getSender();
        String receiver = msg.getReceiver();
        String[] parts = message.split(":");
        if (parts.length < 2) {
            throw new InvalidMessageFormatException("format must be  \"service_name \" : \"opration_name\" : \"parm_1=val_1\" :..:\"param_n = val_n\"");
        }
        AxisConfiguration repo = configurationContext.getAxisConfiguration();
        MessageContext messageContext = configurationContext.createMessageContext();
        parts = this.trimSplited(parts);
        try {
            AxisService axisService = repo.getService(parts[0]);
            if (axisService == null) {
                throw new InvalidMessageFormatException("Service : " + parts[0] + "does not exsist");
            }
            messageContext.setAxisService(axisService);
            AxisOperation axisOperation = axisService.getOperation(new QName(parts[1]));
            if (axisOperation == null) {
                throw new InvalidMessageFormatException("Operation: " + parts[1] + " does not exsist");
            }
            messageContext.setAxisOperation(axisOperation);
            messageContext.setAxisMessage(axisOperation.getMessage("In"));
            Map params = this.getParams(parts, 2);
            SOAPEnvelope soapEnvelope = this.createSoapEnvelope(messageContext, params);
            messageContext.setServerSide(true);
            messageContext.setEnvelope(soapEnvelope);
            TransportInDescription in = configurationContext.getAxisConfiguration().getTransportIn("sms");
            TransportOutDescription out = configurationContext.getAxisConfiguration().getTransportOut("sms");
            messageContext.setProperty(SMSTransportConstents.SEND_TO, (Object)sender);
            messageContext.setProperty(SMSTransportConstents.DESTINATION, (Object)receiver);
            messageContext.setTransportIn(in);
            messageContext.setTransportOut(out);
            this.handleSMSProperties(msg, messageContext);
            return messageContext;
        }
        catch (AxisFault axisFault) {
            this.log.debug((Object)("[DefaultSMSMessageBuilderImpl] Error while extracting the axis2Service \n" + (Object)((Object)axisFault)));
            return null;
        }
    }

    protected void handleSMSProperties(SMSMessage msg, MessageContext messageContext) {
        for (String key : msg.getProperties().keySet()) {
            messageContext.setProperty(key, msg.getProperties().get(key));
        }
    }

    private SOAPEnvelope createSoapEnvelope(MessageContext messageContext, Map params) {
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope inEnvlope = soapFactory.getDefaultEnvelope();
        SOAPBody inBody = inEnvlope.getBody();
        AxisOperation axisOperation = messageContext.getAxisOperation();
        if (axisOperation != null) {
            AxisMessage axisMessage = axisOperation.getMessage("In");
            XmlSchemaElement xmlSchemaElement = axisMessage.getSchemaElement();
            if (xmlSchemaElement == null) {
                OMElement bodyFirstChild = soapFactory.createOMElement(messageContext.getAxisOperation().getName(), (OMContainer)inBody);
                DefaultSMSMessageBuilderImpl.createSOAPMessageWithoutSchema(soapFactory, bodyFirstChild, params);
            } else {
                XmlSchemaComplexType complexType;
                XmlSchemaParticle particle;
                String targetNamespace = xmlSchemaElement.getQName().getNamespaceURI();
                QName bodyFirstChildQName = targetNamespace != null && !"".equals(targetNamespace) ? new QName(targetNamespace, xmlSchemaElement.getName()) : new QName(xmlSchemaElement.getName());
                OMElement bodyFirstChild = soapFactory.createOMElement(bodyFirstChildQName, (OMContainer)inBody);
                XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                if (schemaType instanceof XmlSchemaComplexType && ((particle = (complexType = (XmlSchemaComplexType)schemaType).getParticle()) instanceof XmlSchemaSequence || particle instanceof XmlSchemaAll)) {
                    XmlSchemaGroupBase xmlSchemaGroupBase = (XmlSchemaGroupBase)particle;
                    Iterator iterator = xmlSchemaGroupBase.getItems().getIterator();
                    while (iterator.hasNext()) {
                        XmlSchemaElement innerElement = (XmlSchemaElement)iterator.next();
                        QName qName = innerElement.getQName();
                        if (qName == null && innerElement.getSchemaTypeName().equals(Constants.XSD_ANYTYPE)) {
                            DefaultSMSMessageBuilderImpl.createSOAPMessageWithoutSchema(soapFactory, bodyFirstChild, params);
                            break;
                        }
                        long minOccurs = innerElement.getMinOccurs();
                        boolean nillable = innerElement.isNillable();
                        String name = qName != null ? qName.getLocalPart() : innerElement.getName();
                        OMNamespace ns = qName == null || qName.getNamespaceURI() == null || qName.getNamespaceURI().length() == 0 ? null : soapFactory.createOMNamespace(qName.getNamespaceURI(), null);
                        Object value = params.get(name);
                        if (value != null) {
                            DefaultSMSMessageBuilderImpl.addRequestParameter(soapFactory, bodyFirstChild, ns, name, value);
                            --minOccurs;
                        }
                        if (minOccurs <= 0L || !nillable) continue;
                        OMNamespace xsi = soapFactory.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
                        OMAttribute omAttribute = soapFactory.createOMAttribute("nil", xsi, "true");
                        soapFactory.createOMElement(name, ns, (OMContainer)bodyFirstChild).addAttribute(omAttribute);
                    }
                }
            }
        }
        return inEnvlope;
    }

    private static void createSOAPMessageWithoutSchema(SOAPFactory soapFactory, OMElement bodyFirstChild, Map requestParameterMap) {
        if (requestParameterMap != null) {
            for (String key : requestParameterMap.keySet()) {
                Object value = requestParameterMap.get(key);
                if (value == null) continue;
                DefaultSMSMessageBuilderImpl.addRequestParameter(soapFactory, bodyFirstChild, null, key, value);
            }
        }
    }

    private static void addRequestParameter(SOAPFactory soapFactory, OMElement bodyFirstChild, OMNamespace ns, String key, Object parameter) {
        if (parameter instanceof DataHandler) {
            DataHandler dataHandler = (DataHandler)parameter;
            OMText dataText = bodyFirstChild.getOMFactory().createOMText((Object)dataHandler, true);
            soapFactory.createOMElement(key, ns, (OMContainer)bodyFirstChild).addChild((OMNode)dataText);
        } else {
            String textValue = parameter.toString();
            soapFactory.createOMElement(key, ns, (OMContainer)bodyFirstChild).setText(textValue);
        }
    }

    private Map getParams(String[] array, int startIndex) throws InvalidMessageFormatException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = startIndex; i < array.length; ++i) {
            String[] pramParts = array[i].split(KEY_VALUE_SEPERATOR);
            if ((pramParts = this.trimSplited(pramParts)) == null || pramParts.length != 2) {
                throw new InvalidMessageFormatException("format must be  \"service_name \" : \"opration_name\" : \"parm_1=val_1\" :..:\"param_n = val_n\"");
            }
            params.put(pramParts[0], pramParts[1]);
        }
        return params;
    }

    private String[] trimSplited(String[] parts) {
        if (parts == null) {
            return null;
        }
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        return parts;
    }
}

