/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.sms;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.sms.DefaultSMSMessageBuilderImpl;
import org.apache.axis2.transport.sms.DefaultSMSMessageFormatterImpl;
import org.apache.axis2.transport.sms.InvalidMessageFormatException;
import org.apache.axis2.transport.sms.SMSImplManager;
import org.apache.axis2.transport.sms.SMSMessage;
import org.apache.axis2.transport.sms.SMSMessageBuilder;
import org.apache.axis2.transport.sms.SMSMessageFormatter;
import org.apache.axis2.transport.sms.SMSTransportConstents;
import org.apache.axis2.transport.sms.smpp.SMPPImplManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMSManager {
    private SMSImplManager currentImplimentation;
    private boolean inited;
    private ConfigurationContext configurationContext;
    private SMSMessageBuilder messageBuilder;
    private SMSMessageFormatter messageFormatter;
    private String phoneNumber = null;
    private boolean invertSourceAndDestination = true;
    protected Log log = LogFactory.getLog(this.getClass());

    public void init(TransportInDescription transportInDescription, ConfigurationContext configurationContext) throws AxisFault {
        Parameter builderClass;
        if (!this.inited) {
            this.basicInit((ParameterInclude)transportInDescription, configurationContext);
        }
        if ((builderClass = transportInDescription.getParameter(SMSTransportConstents.BUILDER_CLASS)) == null) {
            this.messageBuilder = new DefaultSMSMessageBuilderImpl();
        } else {
            try {
                this.messageBuilder = (SMSMessageBuilder)Class.forName((String)builderClass.getValue()).newInstance();
            }
            catch (Exception e) {
                throw new AxisFault("Error while instentiating class " + builderClass.getValue(), (Throwable)e);
            }
        }
        this.currentImplimentation.setTransportInDetails(transportInDescription);
        Parameter phoneNum = transportInDescription.getParameter(SMSTransportConstents.PHONE_NUMBER);
        if (phoneNum != null) {
            this.phoneNumber = (String)phoneNum.getValue();
        }
        this.inited = true;
    }

    public void init(TransportOutDescription transportOutDescription, ConfigurationContext configurationContext) throws AxisFault {
        Parameter formatterClass;
        if (!this.inited) {
            this.basicInit((ParameterInclude)transportOutDescription, configurationContext);
        }
        if ((formatterClass = transportOutDescription.getParameter(SMSTransportConstents.FORMATTER_CLASS)) == null) {
            this.messageFormatter = new DefaultSMSMessageFormatterImpl();
        } else {
            try {
                this.messageFormatter = (SMSMessageFormatter)Class.forName((String)formatterClass.getValue()).newInstance();
            }
            catch (Exception e) {
                throw new AxisFault("Error while instentiating the Class: " + formatterClass.getValue(), (Throwable)e);
            }
        }
        this.currentImplimentation.setTransportOutDetails(transportOutDescription);
        Parameter invertS_n_D = transportOutDescription.getParameter(SMSTransportConstents.INVERT_SOURCE_AND_DESTINATION);
        if (invertS_n_D != null) {
            String val = (String)invertS_n_D.getValue();
            if ("false".equals(val)) {
                this.invertSourceAndDestination = false;
            } else if ("true".equals(val)) {
                this.invertSourceAndDestination = true;
            } else {
                this.log.warn((Object)"Invalid parameter value set to the parameter invert_source_and_destination,setting the default value :true ");
                this.invertSourceAndDestination = true;
            }
        }
        this.inited = true;
    }

    private void basicInit(ParameterInclude transportDescription, ConfigurationContext configurationContext) throws AxisFault {
        this.configurationContext = configurationContext;
        Parameter p = transportDescription.getParameter(SMSTransportConstents.IMPLIMENTAION_CLASS);
        if (p == null) {
            this.currentImplimentation = new SMPPImplManager();
        } else {
            String implClass = (String)p.getValue();
            try {
                this.currentImplimentation = (SMSImplManager)Class.forName(implClass).newInstance();
            }
            catch (Exception e) {
                throw new AxisFault("Error while instentiating class " + implClass, (Throwable)e);
            }
        }
        this.currentImplimentation.setSMSInManager(this);
    }

    public void dispatchToAxis2(SMSMessage sms) {
        try {
            MessageContext msgctx = this.messageBuilder.buildMessaage(sms, this.configurationContext);
            msgctx.setReplyTo(new EndpointReference("sms://" + sms.getSender() + "/"));
            AxisEngine.receive((MessageContext)msgctx);
        }
        catch (InvalidMessageFormatException e) {
            this.log.debug((Object)("Invalid message format " + e));
        }
        catch (AxisFault axisFault) {
            this.log.debug((Object)axisFault);
        }
        catch (Throwable e) {
            this.log.debug((Object)"Unknown Exception ", e);
        }
    }

    public void sendSMS(MessageContext messageContext) {
        try {
            SMSMessage sms = this.messageFormatter.formatSMS(messageContext);
            sms.addProperty(SMSTransportConstents.INVERT_SOURCE_AND_DESTINATION, "" + this.invertSourceAndDestination);
            this.currentImplimentation.sendSMS(sms);
        }
        catch (Exception e) {
            this.log.error((Object)"Error while sending the SMS ", (Throwable)e);
        }
    }

    public void sentInfo(SMSMessage sms) {
        this.currentImplimentation.sendSMS(sms);
    }

    public SMSImplManager getCurrentImplimentation() {
        return this.currentImplimentation;
    }

    public void setCurrentImplimentation(SMSImplManager currentImplimentation) {
        this.currentImplimentation = currentImplimentation;
    }

    public void start() {
        this.currentImplimentation.start();
    }

    public void stop() {
        this.currentImplimentation.stop();
    }

    public boolean isInited() {
        return this.inited;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public boolean isInvertSourceAndDestination() {
        return this.invertSourceAndDestination;
    }

    public void setInvertSourceAndDestination(boolean invertSourceAndDestination) {
        this.invertSourceAndDestination = invertSourceAndDestination;
    }
}

