/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.sms.smpp;

import java.io.IOException;
import java.util.Date;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.sms.SMSImplManager;
import org.apache.axis2.transport.sms.SMSManager;
import org.apache.axis2.transport.sms.SMSMessage;
import org.apache.axis2.transport.sms.SMSTransportConstents;
import org.apache.axis2.transport.sms.smpp.SMPPListener;
import org.apache.axis2.transport.sms.smpp.SMPPTransportInDetails;
import org.apache.axis2.transport.sms.smpp.SMPPTransportOutDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.TimeFormatter;

public class SMPPImplManager
implements SMSImplManager {
    protected Log log = LogFactory.getLog(this.getClass());
    private SMPPTransportInDetails smppTransportInDetails = SMPPTransportInDetails.getInstence();
    private SMPPTransportOutDetails smppTransportOutDetails = SMPPTransportOutDetails.getInstence();
    private volatile boolean stop = true;
    private SMSManager smsInManeger;
    private SMPPSession inSession;
    private SMPPSession outSession;
    private static TimeFormatter timeFormatter = new AbsoluteTimeFormatter();
    public static String SOURCE_ADDRESS_TON = "source_address_ton";
    public static String SOURCE_ADDRESS_NPI = "source_address_npi";
    public static String DESTINATION_ADDRESS_TON = "destination_address_ton";
    public static String DESTINATION_ADDRESS_NPI = "destination_address_npi";

    public void start() {
        this.inSession = new SMPPSession();
        try {
            this.inSession.connectAndBind(this.smppTransportInDetails.getHost(), this.smppTransportInDetails.getPort(), new BindParameter(BindType.BIND_RX, this.smppTransportInDetails.getSystemId(), this.smppTransportInDetails.getPassword(), this.smppTransportInDetails.getSystemType(), TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
            SMPPListener listener = new SMPPListener(this.smsInManeger);
            this.inSession.setMessageReceiverListener((MessageReceiverListener)listener);
            this.stop = false;
            System.out.println(" [Axis2] bind and connect to " + this.smppTransportInDetails.getHost() + " : " + this.smppTransportInDetails.getPort() + " on SMPP Transport");
        }
        catch (IOException e) {
            this.log.error((Object)("Unable to conncet" + e));
        }
    }

    public void stop() {
        this.log.info((Object)"Stopping SMPP Transport ...");
        this.stop = true;
        if (this.inSession != null) {
            this.inSession.unbindAndClose();
        }
        if (this.outSession != null) {
            this.outSession.unbindAndClose();
        }
    }

    public void setTransportInDetails(TransportInDescription transportInDetails) throws AxisFault {
        if (transportInDetails == null) {
            throw new AxisFault("No transport in details");
        }
        if (transportInDetails.getParameter(SMSTransportConstents.SYSTEM_TYPE) != null) {
            this.smppTransportInDetails.setSystemType((String)transportInDetails.getParameter(SMSTransportConstents.SYSTEM_TYPE).getValue());
        }
        if (transportInDetails.getParameter(SMSTransportConstents.SYSTEM_ID) == null) {
            throw new AxisFault("System Id not set");
        }
        this.smppTransportInDetails.setSystemId((String)transportInDetails.getParameter(SMSTransportConstents.SYSTEM_ID).getValue());
        if (transportInDetails.getParameter(SMSTransportConstents.PASSWORD) == null) {
            throw new AxisFault("password not set");
        }
        this.smppTransportInDetails.setPassword((String)transportInDetails.getParameter(SMSTransportConstents.PASSWORD).getValue());
        if (transportInDetails.getParameter(SMSTransportConstents.HOST) != null) {
            this.smppTransportInDetails.setHost((String)transportInDetails.getParameter(SMSTransportConstents.HOST).getValue());
        }
        if (transportInDetails.getParameter(SMSTransportConstents.PORT) != null) {
            this.smppTransportInDetails.setPort(Integer.parseInt((String)transportInDetails.getParameter(SMSTransportConstents.PORT).getValue()));
        }
        if (transportInDetails.getParameter(SMSTransportConstents.PHONE_NUMBER) != null) {
            this.smppTransportInDetails.setPhoneNumber((String)transportInDetails.getParameter(SMSTransportConstents.PHONE_NUMBER).getValue());
        }
    }

    public void setTransportOutDetails(TransportOutDescription transportOutDetails) throws AxisFault {
        if (transportOutDetails == null) {
            throw new AxisFault("No transport in details");
        }
        if (transportOutDetails.getParameter(SMSTransportConstents.SYSTEM_TYPE) != null) {
            this.smppTransportOutDetails.setSystemType((String)transportOutDetails.getParameter(SMSTransportConstents.SYSTEM_TYPE).getValue());
        }
        if (transportOutDetails.getParameter(SMSTransportConstents.SYSTEM_ID) == null) {
            throw new AxisFault("System Id not set");
        }
        this.smppTransportOutDetails.setSystemId((String)transportOutDetails.getParameter(SMSTransportConstents.SYSTEM_ID).getValue());
        if (transportOutDetails.getParameter(SMSTransportConstents.PASSWORD) == null) {
            throw new AxisFault("password not set");
        }
        this.smppTransportOutDetails.setPassword((String)transportOutDetails.getParameter(SMSTransportConstents.PASSWORD).getValue());
        if (transportOutDetails.getParameter(SMSTransportConstents.HOST) != null) {
            this.smppTransportOutDetails.setHost((String)transportOutDetails.getParameter(SMSTransportConstents.HOST).getValue());
        }
        if (transportOutDetails.getParameter(SMSTransportConstents.PORT) != null) {
            this.smppTransportOutDetails.setPort(Integer.parseInt((String)transportOutDetails.getParameter(SMSTransportConstents.PORT).getValue()));
        }
        if (transportOutDetails.getParameter(SMSTransportConstents.PHONE_NUMBER) != null) {
            this.smppTransportOutDetails.setPhoneNumber((String)transportOutDetails.getParameter(SMSTransportConstents.PHONE_NUMBER).getValue());
        }
    }

    public void sendSMS(SMSMessage sm) {
        TypeOfNumber sourceTon = TypeOfNumber.UNKNOWN;
        NumberingPlanIndicator sourceNpi = NumberingPlanIndicator.UNKNOWN;
        TypeOfNumber destTon = TypeOfNumber.UNKNOWN;
        NumberingPlanIndicator destNpi = NumberingPlanIndicator.UNKNOWN;
        try {
            if (this.outSession == null) {
                this.outSession = new SMPPSession();
                this.outSession.setEnquireLinkTimer(this.smppTransportOutDetails.getEnquireLinkTimer());
                this.outSession.setTransactionTimer((long)this.smppTransportOutDetails.getTransactionTimer());
                this.outSession.connectAndBind(this.smppTransportOutDetails.getHost(), this.smppTransportOutDetails.getPort(), new BindParameter(BindType.BIND_TX, this.smppTransportOutDetails.getSystemId(), this.smppTransportOutDetails.getPassword(), this.smppTransportOutDetails.getSystemType(), TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
                this.log.debug((Object)("Conected and bind to " + this.smppTransportOutDetails.getHost()));
            }
            boolean invert = true;
            if ("false".equals(sm.getProperties().get(SMSTransportConstents.INVERT_SOURCE_AND_DESTINATION))) {
                invert = false;
            }
            if (invert) {
                if (sm.getProperties().get(DESTINATION_ADDRESS_NPI) != null) {
                    sourceNpi = NumberingPlanIndicator.valueOf((String)((String)sm.getProperties().get(DESTINATION_ADDRESS_NPI)));
                }
                if (sm.getProperties().get(DESTINATION_ADDRESS_TON) != null) {
                    sourceTon = TypeOfNumber.valueOf((String)((String)sm.getProperties().get(DESTINATION_ADDRESS_TON)));
                }
                if (sm.getProperties().get(SOURCE_ADDRESS_NPI) != null) {
                    destNpi = NumberingPlanIndicator.valueOf((String)((String)sm.getProperties().get(SOURCE_ADDRESS_NPI)));
                }
                if (sm.getProperties().get(SOURCE_ADDRESS_TON) != null) {
                    destTon = TypeOfNumber.valueOf((String)((String)sm.getProperties().get(SOURCE_ADDRESS_TON)));
                }
            } else {
                if (sm.getProperties().get(DESTINATION_ADDRESS_NPI) != null) {
                    destNpi = NumberingPlanIndicator.valueOf((String)((String)sm.getProperties().get(DESTINATION_ADDRESS_NPI)));
                }
                if (sm.getProperties().get(DESTINATION_ADDRESS_TON) != null) {
                    destTon = TypeOfNumber.valueOf((String)((String)sm.getProperties().get(DESTINATION_ADDRESS_TON)));
                }
                if (sm.getProperties().get(SOURCE_ADDRESS_NPI) != null) {
                    sourceNpi = NumberingPlanIndicator.valueOf((String)((String)sm.getProperties().get(SOURCE_ADDRESS_NPI)));
                }
                if (sm.getProperties().get(SOURCE_ADDRESS_TON) != null) {
                    sourceTon = TypeOfNumber.valueOf((String)((String)sm.getProperties().get(SOURCE_ADDRESS_TON)));
                }
            }
            String messageId = this.outSession.submitShortMessage("CMT", sourceTon, sourceNpi, sm.getSender(), destTon, destNpi, sm.getReceiver(), new ESMClass(), (byte)0, (byte)1, timeFormatter.format(new Date()), null, new RegisteredDelivery(SMSCDeliveryReceipt.DEFAULT), (byte)0, (DataCoding)new GeneralDataCoding(false, false, MessageClass.CLASS1, Alphabet.ALPHA_DEFAULT), (byte)0, sm.getContent().getBytes(), new OptionalParameter[0]);
            this.log.debug((Object)("Message Submited with id" + messageId));
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to Connect ", (Throwable)e);
        }
        catch (InvalidResponseException e) {
            this.log.debug((Object)"Invalid responce Exception", (Throwable)e);
        }
        catch (PDUException e) {
            this.log.debug((Object)"PDU Exception", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            this.log.debug((Object)e);
        }
        catch (ResponseTimeoutException e) {
            this.log.debug((Object)e);
        }
    }

    public void setSMSInManager(SMSManager manager) {
        this.smsInManeger = manager;
    }

    public SMSManager getSMSInManager() {
        return this.smsInManeger;
    }
}

