/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.udp;

import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.datagram.DatagramEndpoint;
import org.apache.axis2.util.Utils;

public class Endpoint
extends DatagramEndpoint {
    private int port;
    private int maxPacketSize;

    public int getPort() {
        return this.port;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        this.port = ParamUtils.getOptionalParamInt(params, "transport.udp.port", -1);
        if (this.port == -1) {
            return false;
        }
        this.maxPacketSize = ParamUtils.getOptionalParamInt(params, "transport.udp.maxPacketSize", 1024);
        return super.loadConfiguration(params);
    }

    public EndpointReference[] getEndpointReferences(String ip) throws AxisFault {
        if (ip == null) {
            try {
                ip = Utils.getIpAddress((AxisConfiguration)this.getListener().getConfigurationContext().getAxisConfiguration());
            }
            catch (SocketException ex) {
                throw new AxisFault("Unable to determine the host's IP address", (Throwable)ex);
            }
        }
        return new EndpointReference[]{new EndpointReference("udp://" + ip + ":" + this.getPort() + "?contentType=" + this.getContentType())};
    }
}

