/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.base.MessageLevelMetricsCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricsCollector {
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_TRANSPORT = 1;
    public static final int LEVEL_FULL = 2;
    private static final Long ONE = 1L;
    private int level = 2;
    private long messagesReceived;
    private long faultsReceiving;
    private long timeoutsReceiving;
    private long bytesReceived;
    private long minSizeReceived;
    private long maxSizeReceived;
    private double avgSizeReceived;
    private long messagesSent;
    private long faultsSending;
    private long timeoutsSending;
    private long bytesSent;
    private long minSizeSent;
    private long maxSizeSent;
    private double avgSizeSent;
    private final Map<Integer, Long> responseCodeTable = Collections.synchronizedMap(new HashMap());
    private long lastResetTime = System.currentTimeMillis();

    public void reset() {
        this.messagesReceived = 0L;
        this.faultsReceiving = 0L;
        this.timeoutsReceiving = 0L;
        this.bytesReceived = 0L;
        this.minSizeReceived = 0L;
        this.maxSizeReceived = 0L;
        this.avgSizeReceived = 0.0;
        this.messagesSent = 0L;
        this.faultsSending = 0L;
        this.timeoutsSending = 0L;
        this.bytesSent = 0L;
        this.minSizeSent = 0L;
        this.maxSizeSent = 0L;
        this.avgSizeSent = 0.0;
        this.responseCodeTable.clear();
        this.lastResetTime = System.currentTimeMillis();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public long getLastResetTime() {
        return this.lastResetTime;
    }

    public long getMessagesReceived() {
        return this.messagesReceived;
    }

    public long getFaultsReceiving() {
        return this.faultsReceiving;
    }

    public long getTimeoutsReceiving() {
        return this.timeoutsReceiving;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getMessagesSent() {
        return this.messagesSent;
    }

    public long getFaultsSending() {
        return this.faultsSending;
    }

    public long getTimeoutsSending() {
        return this.timeoutsSending;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getMinSizeReceived() {
        return this.minSizeReceived;
    }

    public long getMaxSizeReceived() {
        return this.maxSizeReceived;
    }

    public long getMinSizeSent() {
        return this.minSizeSent;
    }

    public long getMaxSizeSent() {
        return this.maxSizeSent;
    }

    public double getAvgSizeReceived() {
        return this.avgSizeReceived;
    }

    public double getAvgSizeSent() {
        return this.avgSizeSent;
    }

    public Map<Integer, Long> getResponseCodeTable() {
        return this.responseCodeTable;
    }

    public synchronized void incrementMessagesReceived() {
        ++this.messagesReceived;
    }

    public synchronized void incrementFaultsReceiving() {
        ++this.faultsReceiving;
    }

    public synchronized void incrementTimeoutsReceiving() {
        ++this.timeoutsReceiving;
    }

    public synchronized void incrementBytesReceived(long size) {
        this.bytesReceived += size;
    }

    public synchronized void incrementMessagesSent() {
        ++this.messagesSent;
    }

    public synchronized void incrementFaultsSending() {
        ++this.faultsSending;
    }

    public synchronized void incrementTimeoutsSending() {
        ++this.timeoutsSending;
    }

    public synchronized void incrementBytesSent(long size) {
        this.bytesSent += size;
    }

    public synchronized void notifyReceivedMessageSize(long size) {
        if (this.minSizeReceived == 0L || size < this.minSizeReceived) {
            this.minSizeReceived = size;
        }
        if (size > this.maxSizeReceived) {
            this.maxSizeReceived = size;
        }
        this.avgSizeReceived = this.avgSizeReceived == 0.0 ? (double)size : (this.avgSizeReceived + (double)size) / 2.0;
    }

    public synchronized void notifySentMessageSize(long size) {
        if (this.minSizeSent == 0L || size < this.minSizeSent) {
            this.minSizeSent = size;
        }
        if (size > this.maxSizeSent) {
            this.maxSizeSent = size;
        }
        this.avgSizeSent = this.avgSizeSent == 0.0 ? (double)size : (this.avgSizeSent + (double)size) / 2.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResponseCode(int respCode) {
        Map<Integer, Long> map = this.responseCodeTable;
        synchronized (map) {
            Long o = this.responseCodeTable.get(respCode);
            if (o == null) {
                this.responseCodeTable.put(respCode, ONE);
            } else {
                this.responseCodeTable.put(respCode, o + 1L);
            }
        }
    }

    private MessageLevelMetricsCollector getMsgLevelMetrics(MessageContext mc) {
        if (mc != null && this.level == 2) {
            return (MessageLevelMetricsCollector)mc.getProperty("METRICS_COLLECTOR");
        }
        return null;
    }

    public void incrementMessagesReceived(MessageContext mc) {
        this.incrementMessagesReceived();
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.incrementMessagesReceived();
        }
    }

    public void incrementFaultsReceiving(int errorCode, MessageContext mc) {
        this.incrementFaultsReceiving();
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.incrementFaultsReceiving(errorCode);
        }
    }

    public void incrementTimeoutsReceiving(MessageContext mc) {
        this.incrementTimeoutsReceiving();
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.incrementTimeoutsReceiving();
        }
    }

    public void incrementBytesReceived(MessageContext mc, long size) {
        this.incrementBytesReceived(size);
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.incrementBytesReceived(size);
        }
    }

    public void incrementMessagesSent(MessageContext mc) {
        this.incrementMessagesSent();
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.incrementMessagesSent();
        }
    }

    public void incrementFaultsSending(int errorCode, MessageContext mc) {
        this.incrementFaultsSending();
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.incrementFaultsSending(errorCode);
        }
    }

    public void incrementTimeoutsSending(MessageContext mc) {
        this.incrementTimeoutsSending();
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.incrementTimeoutsSending();
        }
    }

    public void incrementBytesSent(MessageContext mc, long size) {
        this.incrementBytesSent(size);
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.incrementBytesSent(size);
        }
    }

    public void notifyReceivedMessageSize(MessageContext mc, long size) {
        this.notifyReceivedMessageSize(size);
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.notifyReceivedMessageSize(size);
        }
    }

    public void notifySentMessageSize(MessageContext mc, long size) {
        this.notifySentMessageSize(size);
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.notifySentMessageSize(size);
        }
    }

    public void reportResponseCode(MessageContext mc, int respCode) {
        this.reportResponseCode(respCode);
        MessageLevelMetricsCollector m = this.getMsgLevelMetrics(mc);
        if (m != null) {
            m.reportResponseCode(respCode);
        }
    }
}

