/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.axis2;

import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.testkit.util.LogManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class LogAspect {
    private static final Log log = LogFactory.getLog(LogAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="call(void org.apache.axis2.transport.MessageFormatter.writeTo(       org.apache.axis2.context.MessageContext, org.apache.axiom.om.OMOutputFormat,       java.io.OutputStream, boolean)) && args(msgContext, format, out, preserve)")
    public void aroundWriteTo(ProceedingJoinPoint proceedingJoinPoint, MessageContext msgContext, OMOutputFormat format, OutputStream out, boolean preserve) throws Throwable {
        OutputStream log = LogManager.INSTANCE.createLog("formatter");
        try {
            TeeOutputStream tee = new TeeOutputStream(out, log);
            proceedingJoinPoint.proceed(new Object[]{msgContext, format, tee, preserve});
        }
        finally {
            log.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterReturning(pointcut="call(javax.activation.DataSource org.apache.axis2.format.MessageFormatterEx.getDataSource(..))", returning="dataSource")
    public void afterGetDataSource(DataSource dataSource) {
        try {
            OutputStream out = LogManager.INSTANCE.createLog("formatter");
            try {
                InputStream in = dataSource.getInputStream();
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    in.close();
                }
            }
            finally {
                out.close();
            }
        }
        catch (Throwable ex) {
            log.error((Object)"Unable to dump message", ex);
        }
    }

    @Around(value="call(org.apache.axiom.om.OMElement org.apache.axis2.builder.Builder.processDocument(       java.io.InputStream, java.lang.String, org.apache.axis2.context.MessageContext)) && args(in, contentType, msgContext)")
    public Object aroundProcessDocument(ProceedingJoinPoint proceedingJoinPoint, InputStream in, String contentType, MessageContext msgContext) throws Throwable {
        TeeInputStream tee;
        if (in == null) {
            tee = null;
        } else {
            OutputStream log = LogManager.INSTANCE.createLog("builder");
            tee = new TeeInputStream(in, log, true);
        }
        return proceedingJoinPoint.proceed(new Object[]{tee, contentType, msgContext});
    }
}

