/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.axis2.client;

import javax.mail.internet.ContentType;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.axiom.attachments.Attachments;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.testkit.MessageExchangeValidator;
import org.apache.axis2.transport.testkit.axis2.client.AxisTestClientConfigurator;
import org.apache.axis2.transport.testkit.axis2.client.AxisTestClientContext;
import org.apache.axis2.transport.testkit.axis2.util.MessageLevelMetricsCollectorImpl;
import org.apache.axis2.transport.testkit.channel.Channel;
import org.apache.axis2.transport.testkit.client.ClientOptions;
import org.apache.axis2.transport.testkit.client.TestClient;
import org.apache.axis2.transport.testkit.message.AxisMessage;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.TearDown;
import org.apache.axis2.transport.testkit.tests.Transient;
import org.apache.axis2.transport.testkit.util.ContentTypeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Name(value="axis")
public class AxisTestClient
implements TestClient,
MessageExchangeValidator {
    private static final Log log = LogFactory.getLog(AxisTestClient.class);
    @Transient
    private AxisTestClientConfigurator[] configurators;
    @Transient
    private TransportSender sender;
    @Transient
    protected ServiceClient serviceClient;
    @Transient
    protected Options axisOptions;
    private long messagesSent;
    private long bytesSent;
    private MessageLevelMetricsCollectorImpl metrics;

    @Setup
    private void setUp(AxisTestClientContext context, Channel channel, AxisTestClientConfigurator[] configurators) throws Exception {
        this.configurators = configurators;
        this.sender = context.getSender();
        this.serviceClient = new ServiceClient(context.getConfigurationContext(), null);
        this.axisOptions = new Options();
        this.axisOptions.setTo(channel.getEndpointReference());
        this.serviceClient.setOptions(this.axisOptions);
    }

    @TearDown
    private void tearDown() throws Exception {
        this.serviceClient.cleanup();
    }

    public ContentType getContentType(ClientOptions options, ContentType contentType) {
        String charset = options.getCharset();
        if (charset == null) {
            return contentType;
        }
        return ContentTypeUtil.addCharset(contentType, options.getCharset());
    }

    public void beforeSend() throws Exception {
        if (this.sender instanceof ManagementSupport) {
            ManagementSupport sender = (ManagementSupport)this.sender;
            this.messagesSent = sender.getMessagesSent();
            this.bytesSent = sender.getBytesSent();
            this.metrics = new MessageLevelMetricsCollectorImpl();
        } else {
            this.metrics = null;
        }
    }

    protected MessageContext send(ClientOptions options, AxisMessage message, QName operationQName, boolean block, String resultMessageLabel) throws Exception {
        OperationClient mepClient = this.serviceClient.createClient(operationQName);
        MessageContext mc = new MessageContext();
        mc.setProperty("messageType", (Object)message.getMessageType());
        mc.setEnvelope(message.getEnvelope());
        Attachments attachments = message.getAttachments();
        if (attachments != null) {
            mc.setAttachmentMap(attachments);
            mc.setDoingSwA(true);
            mc.setProperty("enableSwA", (Object)true);
        }
        for (AxisTestClientConfigurator configurator : this.configurators) {
            configurator.setupRequestMessageContext(mc);
        }
        mc.setProperty("CHARACTER_SET_ENCODING", (Object)options.getCharset());
        mc.setServiceContext(this.serviceClient.getServiceContext());
        if (this.metrics != null) {
            mc.setProperty("METRICS_COLLECTOR", (Object)this.metrics);
        }
        mepClient.addMessageContext(mc);
        mepClient.execute(block);
        return resultMessageLabel == null ? null : mepClient.getMessageContext(resultMessageLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterReceive() throws Exception {
        if (this.sender instanceof ManagementSupport) {
            ManagementSupport sender = (ManagementSupport)this.sender;
            MessageLevelMetricsCollectorImpl messageLevelMetricsCollectorImpl = this.metrics;
            synchronized (messageLevelMetricsCollectorImpl) {
                long start = System.currentTimeMillis();
                while (true) {
                    try {
                        Assert.assertEquals((long)1L, (long)this.metrics.getMessagesSent());
                        Assert.assertEquals((long)(this.messagesSent + 1L), (long)sender.getMessagesSent());
                        long thisBytesSent = this.metrics.getBytesSent();
                        Assert.assertTrue((String)"No increase in bytes sent in message level metrics", (thisBytesSent != 0L ? 1 : 0) != 0);
                        long newBytesSent = sender.getBytesSent();
                        Assert.assertTrue((String)"No increase in bytes sent in transport level metrics", (newBytesSent > this.bytesSent ? 1 : 0) != 0);
                        Assert.assertEquals((String)"Mismatch between message and transport level metrics", (long)thisBytesSent, (long)(newBytesSent - this.bytesSent));
                    }
                    catch (AssertionFailedError ex) {
                        long remaining = start + 5000L - System.currentTimeMillis();
                        if (remaining <= 0L) {
                            throw ex;
                        }
                        log.debug((Object)("The transport sender didn't update the metrics yet (" + ex.getMessage() + "). Waiting for " + remaining + " ms."));
                        this.metrics.wait(remaining);
                        continue;
                    }
                    break;
                }
            }
            log.debug((Object)"Message level metrics check OK");
        }
    }
}

