/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.axis2.client;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.CustomAxisConfigurator;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.testkit.axis2.TransportDescriptionFactory;
import org.apache.axis2.transport.testkit.axis2.client.AxisTestClientContextConfigurator;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.TearDown;
import org.apache.axis2.transport.testkit.tests.Transient;

public class AxisTestClientContext {
    public static final AxisTestClientContext INSTANCE = new AxisTestClientContext();
    @Transient
    private TransportSender sender;
    @Transient
    private ConfigurationContext cfgCtx;
    @Transient
    private ListenerManager listenerManager;

    private AxisTestClientContext() {
    }

    @Setup
    private void setUp(TransportDescriptionFactory tdf, AxisTestClientContextConfigurator[] configurators) throws Exception {
        this.cfgCtx = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)new CustomAxisConfigurator());
        AxisConfiguration axisCfg = this.cfgCtx.getAxisConfiguration();
        TransportOutDescription trpOutDesc = tdf.createTransportOutDescription();
        axisCfg.addTransportOut(trpOutDesc);
        this.sender = trpOutDesc.getSender();
        this.sender.init(this.cfgCtx, trpOutDesc);
        boolean useListener = false;
        for (AxisTestClientContextConfigurator configurator : configurators) {
            if (!configurator.isTransportListenerRequired()) continue;
            useListener = true;
            break;
        }
        TransportInDescription trpInDesc = useListener ? tdf.createTransportInDescription() : null;
        for (AxisTestClientContextConfigurator configurator : configurators) {
            configurator.setupTransport(trpInDesc, trpOutDesc);
        }
        if (useListener) {
            this.listenerManager = new ListenerManager();
            this.listenerManager.init(this.cfgCtx);
            this.cfgCtx.setTransportManager(this.listenerManager);
            this.listenerManager.addListener(trpInDesc, false);
            this.listenerManager.start();
        }
    }

    public TransportSender getSender() {
        return this.sender;
    }

    @TearDown
    private void tearDown() throws Exception {
        this.sender.stop();
        if (this.listenerManager != null) {
            this.listenerManager.stop();
            this.listenerManager.destroy();
        }
        this.cfgCtx.terminate();
    }

    public ConfigurationContext getConfigurationContext() {
        return this.cfgCtx;
    }
}

