/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.axis2.endpoint;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.UtilsTransportServer;
import org.apache.axis2.transport.testkit.axis2.TransportDescriptionFactory;
import org.apache.axis2.transport.testkit.axis2.endpoint.AxisTestEndpointContextConfigurator;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.TearDown;
import org.apache.axis2.transport.testkit.tests.Transient;

public class AxisTestEndpointContext {
    public static final AxisTestEndpointContext INSTANCE = new AxisTestEndpointContext();
    @Transient
    private TransportInDescription trpInDesc;
    @Transient
    private UtilsTransportServer server;

    private AxisTestEndpointContext() {
    }

    @Setup
    private void setUp(TransportDescriptionFactory tdf, AxisTestEndpointContextConfigurator[] configurators) throws Exception {
        this.server = new UtilsTransportServer();
        TransportOutDescription trpOutDesc = tdf.createTransportOutDescription();
        this.trpInDesc = tdf.createTransportInDescription();
        this.server.addTransport(this.trpInDesc, trpOutDesc);
        for (AxisTestEndpointContextConfigurator configurator : configurators) {
            configurator.setupTransport(this.trpInDesc, trpOutDesc);
        }
        ConfigurationContext cfgCtx = this.server.getConfigurationContext();
        cfgCtx.setContextRoot("/");
        cfgCtx.setServicePath("services");
        AxisConfiguration axisConfiguration = this.server.getAxisConfiguration();
        this.server.start();
    }

    @TearDown
    private void tearDown() throws Exception {
        this.server.stop();
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.server.getAxisConfiguration();
    }

    public TransportListener getTransportListener() {
        return this.trpInDesc.getReceiver();
    }

    public String getTransportName() {
        return this.trpInDesc.getName();
    }

    public String getEPR(AxisService service) throws AxisFault {
        EndpointReference[] endpointReferences = this.trpInDesc.getReceiver().getEPRsForService(service.getName(), "localhost");
        return endpointReferences != null && endpointReferences.length > 0 ? endpointReferences[0].getAddress() : null;
    }
}

