/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.mail.internet.ContentType;
import org.apache.axis2.transport.testkit.client.AsyncTestClient;
import org.apache.axis2.transport.testkit.client.ClientOptions;
import org.apache.axis2.transport.testkit.http.HttpChannel;
import org.apache.axis2.transport.testkit.message.RESTMessage;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.Transient;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="java.net")
public class JavaNetRESTClient
implements AsyncTestClient<RESTMessage> {
    @Transient
    private HttpChannel channel;

    @Setup
    private void setUp(HttpChannel channel) {
        this.channel = channel;
    }

    @Override
    public ContentType getContentType(ClientOptions options, ContentType contentType) {
        return contentType;
    }

    @Override
    public void sendMessage(ClientOptions options, ContentType contentType, RESTMessage message) throws Exception {
        StringBuilder url = new StringBuilder();
        url.append(this.channel.getEndpointReference().getAddress());
        url.append("/default");
        String queryString = message.getQueryString();
        if (queryString.length() > 0) {
            url.append('?');
            url.append(queryString);
        }
        URLConnection connection = new URL(url.toString()).openConnection();
        connection.setDoInput(true);
        InputStream in = connection.getInputStream();
        IOUtils.copy((InputStream)in, (OutputStream)System.out);
        in.close();
    }
}

