/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axis2.transport.testkit.http.JettyAsyncEndpoint;
import org.apache.axis2.transport.testkit.message.IncomingMessage;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.Transient;
import org.apache.axis2.transport.testkit.util.LogManager;
import org.apache.commons.io.IOUtils;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyByteArrayAsyncEndpoint
extends JettyAsyncEndpoint<byte[]> {
    @Transient
    private LogManager logManager;

    @Setup
    private void setUp(LogManager logManager) throws Exception {
        this.logManager = logManager;
    }

    @Override
    protected IncomingMessage<byte[]> handle(HttpRequest request) throws HttpException, IOException {
        ContentType contentType;
        byte[] data = IOUtils.toByteArray((InputStream)request.getInputStream());
        this.logRequest(request, data);
        try {
            contentType = new ContentType(request.getContentType());
        }
        catch (ParseException ex) {
            throw new HttpException(500, "Unparsable Content-Type");
        }
        return new IncomingMessage<byte[]>(contentType, data);
    }

    private void logRequest(HttpRequest request, byte[] data) throws IOException {
        OutputStream out = this.logManager.createLog("jetty");
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out), false);
        Enumeration e = request.getFieldNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Enumeration e2 = request.getFieldValues(name);
            while (e2.hasMoreElements()) {
                pw.print(name);
                pw.print(": ");
                pw.println((String)e2.nextElement());
            }
        }
        pw.println();
        pw.flush();
        out.write(data);
    }
}

