/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests.async;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.transport.testkit.MessageTestData;
import org.apache.axis2.transport.testkit.channel.AsyncChannel;
import org.apache.axis2.transport.testkit.client.AsyncTestClient;
import org.apache.axis2.transport.testkit.endpoint.AsyncEndpoint;
import org.apache.axis2.transport.testkit.message.XMLMessage;
import org.apache.axis2.transport.testkit.name.Key;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.name.Named;
import org.apache.axis2.transport.testkit.tests.async.AsyncMessageTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="AsyncXML")
public class XMLAsyncMessageTestCase
extends AsyncMessageTestCase<XMLMessage> {
    private final XMLMessage.Type xmlMessageType;
    private final MessageTestData data;

    public XMLAsyncMessageTestCase(AsyncChannel channel, AsyncTestClient<XMLMessage> client, AsyncEndpoint<XMLMessage> endpoint, XMLMessage.Type xmlMessageType, MessageTestData data, Object ... resources) {
        super(channel, client, endpoint, xmlMessageType.getContentType(), data.getCharset(), resources);
        this.xmlMessageType = xmlMessageType;
        this.data = data;
    }

    @Key(value="messageType")
    public XMLMessage.Type getXmlMessageType() {
        return this.xmlMessageType;
    }

    @Named
    public MessageTestData getData() {
        return this.data;
    }

    @Override
    protected XMLMessage prepareMessage() throws Exception {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement orgElement = factory.createOMElement(new QName("root"));
        orgElement.setText(this.data.getText());
        return new XMLMessage(orgElement, this.xmlMessageType);
    }

    @Override
    protected void checkMessageData(XMLMessage expected, XMLMessage actual) throws Exception {
        OMElement element = actual.getPayload();
        OMElement orgElement = expected.getPayload();
        XMLAsyncMessageTestCase.assertEquals((Object)orgElement.getQName(), (Object)element.getQName());
        XMLAsyncMessageTestCase.assertEquals((String)this.data.getText(), (String)element.getText());
    }
}

