/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport;

import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.UtilsTransportServer;

public abstract class AbstractTransportTest
extends TestCase {
    private UtilsTransportServer server;

    protected void setUp() throws Exception {
        String agentName = System.getProperty("jmx.agent.name", "org.apache.synapse");
        System.setProperty("jmx.agent.name", agentName + "-server");
        this.server = this.createServer();
        this.server.start();
        System.setProperty("jmx.agent.name", agentName);
    }

    protected void tearDown() throws Exception {
        this.server.stop();
        this.server = null;
    }

    protected abstract UtilsTransportServer createServer() throws Exception;

    protected OMElement createPayload(String textValue) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://localhost/axis2/services/EchoXMLService", "my");
        OMElement method = fac.createOMElement("echoOMElement", omNs);
        OMElement value = fac.createOMElement("myValue", omNs);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, textValue));
        method.addChild((OMNode)value);
        return method;
    }

    protected OMElement createPayload() {
        return this.createPayload("omTextValue");
    }

    protected void assertEchoResponse(String textValue, OMElement element) {
        AbstractTransportTest.assertEquals((String)"echoOMElementResponse", (String)element.getLocalName());
        AbstractTransportTest.assertEquals((String)"http://localhost/axis2/services/EchoXMLService", (String)element.getNamespace().getNamespaceURI());
        OMElement valueElement = element.getFirstElement();
        AbstractTransportTest.assertEquals((String)"myValue", (String)valueElement.getLocalName());
        AbstractTransportTest.assertEquals((String)"http://localhost/axis2/services/EchoXMLService", (String)valueElement.getNamespace().getNamespaceURI());
        AbstractTransportTest.assertEquals((String)textValue, (String)valueElement.getText());
    }

    protected void assertEchoResponse(OMElement element) {
        this.assertEchoResponse("omTextValue", element);
    }

    protected void assertSOAPEchoResponse(String textValue, XMLStreamReader reader) {
        SOAPEnvelope env = new StAXSOAPModelBuilder(reader).getSOAPEnvelope();
        this.assertEchoResponse(textValue, env.getBody().getFirstElement());
    }

    protected void assertSOAPEchoResponse(XMLStreamReader reader) {
        this.assertSOAPEchoResponse("omTextValue", reader);
    }

    protected ConfigurationContext getClientCfgCtx() throws Exception {
        AxisConfiguration axisCfg = new AxisConfiguration();
        ConfigurationContext cfgCtx = new ConfigurationContext(axisCfg);
        return cfgCtx;
    }
}

