/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import org.apache.axis2.transport.testkit.AdapterUtils;
import org.apache.axis2.transport.testkit.ManagedTestSuite;
import org.apache.axis2.transport.testkit.MessageTestData;
import org.apache.axis2.transport.testkit.channel.AsyncChannel;
import org.apache.axis2.transport.testkit.channel.Channel;
import org.apache.axis2.transport.testkit.channel.RequestResponseChannel;
import org.apache.axis2.transport.testkit.client.AsyncTestClient;
import org.apache.axis2.transport.testkit.client.RequestResponseTestClient;
import org.apache.axis2.transport.testkit.client.TestClient;
import org.apache.axis2.transport.testkit.endpoint.AsyncEndpoint;
import org.apache.axis2.transport.testkit.endpoint.InOutEndpoint;
import org.apache.axis2.transport.testkit.message.AxisMessage;
import org.apache.axis2.transport.testkit.message.MessageDecoder;
import org.apache.axis2.transport.testkit.message.MessageEncoder;
import org.apache.axis2.transport.testkit.message.RESTMessage;
import org.apache.axis2.transport.testkit.message.XMLMessage;
import org.apache.axis2.transport.testkit.tests.async.BinaryTestCase;
import org.apache.axis2.transport.testkit.tests.async.LargeSOAPAsyncMessageTestCase;
import org.apache.axis2.transport.testkit.tests.async.RESTTestCase;
import org.apache.axis2.transport.testkit.tests.async.SwATestCase;
import org.apache.axis2.transport.testkit.tests.async.TextPlainTestCase;
import org.apache.axis2.transport.testkit.tests.async.XMLAsyncMessageTestCase;
import org.apache.axis2.transport.testkit.tests.echo.XMLRequestResponseMessageTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportTestSuiteBuilder {
    public static final String testString = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    public static final MessageTestData ASCII_TEST_DATA = new MessageTestData("ASCII", "test string", "us-ascii");
    public static final MessageTestData UTF8_TEST_DATA = new MessageTestData("UTF8", "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre", "UTF-8");
    public static final MessageTestData LATIN1_TEST_DATA = new MessageTestData("Latin1", "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre", "ISO-8859-1");
    private static final MessageTestData[] messageTestData = new MessageTestData[]{ASCII_TEST_DATA, UTF8_TEST_DATA, LATIN1_TEST_DATA};
    private static final RESTMessage restTestMessage1 = new RESTMessage(new RESTMessage.Parameter[]{new RESTMessage.Parameter("param1", "value1"), new RESTMessage.Parameter("param2", "value2")});
    private static final RESTMessage restTestMessage2 = new RESTMessage(new RESTMessage.Parameter[]{new RESTMessage.Parameter("param", "value1"), new RESTMessage.Parameter("param", "value2")});
    private final ManagedTestSuite suite;
    private final List<Object[]> environments = new LinkedList<Object[]>();
    private final ResourceList<AsyncChannel> asyncChannels = new ResourceList();
    private final ResourceList<AsyncTestClient<byte[]>> byteAsyncClients = new ResourceList();
    private final ResourceList<AsyncTestClient<XMLMessage>> xmlAsyncClients = new ResourceList();
    private final ResourceList<AsyncTestClient<RESTMessage>> restAsyncClients = new ResourceList();
    private final ResourceList<AsyncTestClient<String>> stringAsyncClients = new ResourceList();
    private final ResourceList<AsyncEndpoint<byte[]>> byteAsyncEndpoints = new ResourceList();
    private final ResourceList<AsyncEndpoint<XMLMessage>> xmlAsyncEndpoints = new ResourceList();
    private final ResourceList<AsyncEndpoint<RESTMessage>> restAsyncEndpoints = new ResourceList();
    private final ResourceList<AsyncEndpoint<String>> stringAsyncEndpoints = new ResourceList();
    private final ResourceList<RequestResponseChannel> requestResponseChannels = new ResourceList();
    private final ResourceList<RequestResponseTestClient<XMLMessage, XMLMessage>> xmlRequestResponseClients = new ResourceList();
    private final ResourceList<InOutEndpoint> echoEndpoints = new ResourceList();

    public TransportTestSuiteBuilder(ManagedTestSuite suite) {
        this.suite = suite;
        try {
            suite.addExclude("(&(client=*)(endpoint=*)(!(|(client=axis)(endpoint=axis))))");
        }
        catch (ParseException ex) {
            throw new Error(ex);
        }
    }

    public void addEnvironment(Object ... resources) {
        this.environments.add(resources);
    }

    public void addAsyncChannel(AsyncChannel channel, Object ... relatedResources) {
        this.asyncChannels.add(channel, relatedResources);
    }

    public void addAxisAsyncTestClient(AsyncTestClient<AxisMessage> client, Object ... relatedResources) {
        this.byteAsyncClients.add(AdapterUtils.adapt(client, MessageEncoder.BINARY_WRAPPER), relatedResources);
        this.xmlAsyncClients.add(AdapterUtils.adapt(client, MessageEncoder.XML_TO_AXIS), relatedResources);
        this.stringAsyncClients.add(AdapterUtils.adapt(client, MessageEncoder.TEXT_WRAPPER), relatedResources);
    }

    public void addByteArrayAsyncTestClient(AsyncTestClient<byte[]> client, Object ... relatedResources) {
        this.byteAsyncClients.add(client, relatedResources);
        this.xmlAsyncClients.add(AdapterUtils.adapt(client, MessageEncoder.XML_TO_BYTE), relatedResources);
        this.stringAsyncClients.add(AdapterUtils.adapt(client, MessageEncoder.STRING_TO_BYTE), relatedResources);
    }

    public void addRESTAsyncTestClient(AsyncTestClient<RESTMessage> client, Object ... relatedResources) {
        this.restAsyncClients.add(client, relatedResources);
    }

    public void addStringAsyncTestClient(AsyncTestClient<String> client, Object ... relatedResources) {
        this.xmlAsyncClients.add(AdapterUtils.adapt(client, MessageEncoder.XML_TO_STRING), relatedResources);
        this.stringAsyncClients.add(client, relatedResources);
    }

    public void addAxisAsyncEndpoint(AsyncEndpoint<AxisMessage> endpoint, Object ... relatedResources) {
        this.byteAsyncEndpoints.add(AdapterUtils.adapt(endpoint, MessageDecoder.AXIS_TO_BYTE), relatedResources);
        this.xmlAsyncEndpoints.add(AdapterUtils.adapt(endpoint, MessageDecoder.AXIS_TO_XML), relatedResources);
        this.restAsyncEndpoints.add(AdapterUtils.adapt(endpoint, MessageDecoder.AXIS_TO_REST), relatedResources);
        this.stringAsyncEndpoints.add(AdapterUtils.adapt(endpoint, MessageDecoder.AXIS_TO_STRING), relatedResources);
    }

    public void addByteArrayAsyncEndpoint(AsyncEndpoint<byte[]> endpoint, Object ... relatedResources) {
        this.byteAsyncEndpoints.add(endpoint, relatedResources);
        this.xmlAsyncEndpoints.add(AdapterUtils.adapt(endpoint, MessageDecoder.BYTE_TO_XML), relatedResources);
        this.stringAsyncEndpoints.add(AdapterUtils.adapt(endpoint, MessageDecoder.BYTE_TO_STRING), relatedResources);
    }

    public void addRESTAsyncEndpoint(AsyncEndpoint<RESTMessage> endpoint, Object ... relatedResources) {
        this.restAsyncEndpoints.add(endpoint, relatedResources);
    }

    public void addRequestResponseChannel(RequestResponseChannel channel, Object ... relatedResources) {
        this.requestResponseChannels.add(channel, relatedResources);
    }

    public void addAxisRequestResponseTestClient(RequestResponseTestClient<AxisMessage, AxisMessage> client, Object ... relatedResources) {
        this.xmlRequestResponseClients.add(AdapterUtils.adapt(client, MessageEncoder.XML_TO_AXIS, MessageDecoder.AXIS_TO_XML), relatedResources);
    }

    public void addByteArrayRequestResponseTestClient(RequestResponseTestClient<byte[], byte[]> client, Object ... relatedResources) {
        this.xmlRequestResponseClients.add(AdapterUtils.adapt(client, MessageEncoder.XML_TO_BYTE, MessageDecoder.BYTE_TO_XML), relatedResources);
    }

    public void addStringRequestResponseTestClient(RequestResponseTestClient<String, String> client, Object ... relatedResources) {
        this.xmlRequestResponseClients.add(AdapterUtils.adapt(client, MessageEncoder.XML_TO_STRING, MessageDecoder.STRING_TO_XML), relatedResources);
    }

    public void addEchoEndpoint(InOutEndpoint endpoint, Object ... relatedResources) {
        this.echoEndpoints.add(endpoint, relatedResources);
    }

    private Object[] merge(Object[] environment, ResourceRelation<?> ... resourceRelations) {
        LinkedHashSet<Object> resources = new LinkedHashSet<Object>();
        resources.addAll(Arrays.asList(environment));
        for (ResourceRelation<?> resourceRelation : resourceRelations) {
            resources.addAll(Arrays.asList(resourceRelation.getRelatedResources()));
        }
        return resources.toArray();
    }

    private void build(Object[] env) {
        Object[] resources;
        for (ResourceRelation<AsyncChannel> resourceRelation : this.asyncChannels) {
            for (ResourceRelation<AsyncTestClient<XMLMessage>> resourceRelation2 : this.xmlAsyncClients) {
                for (ResourceRelation<AsyncEndpoint<XMLMessage>> resourceRelation3 : this.xmlAsyncEndpoints) {
                    resources = this.merge(env, resourceRelation, resourceRelation2, resourceRelation3);
                    for (MessageTestData data : messageTestData) {
                        for (XMLMessage.Type type : XMLMessage.Type.values()) {
                            if (type == XMLMessage.Type.SWA) continue;
                            this.suite.addTest((Test)new XMLAsyncMessageTestCase(resourceRelation.getPrimaryResource(), resourceRelation2.getPrimaryResource(), resourceRelation3.getPrimaryResource(), type, data, resources));
                        }
                    }
                    this.suite.addTest((Test)new SwATestCase(resourceRelation.getPrimaryResource(), resourceRelation2.getPrimaryResource(), resourceRelation3.getPrimaryResource(), resources));
                    this.suite.addTest((Test)new LargeSOAPAsyncMessageTestCase(resourceRelation.getPrimaryResource(), resourceRelation2.getPrimaryResource(), resourceRelation3.getPrimaryResource(), resources));
                }
            }
            for (ResourceRelation<TestClient> resourceRelation4 : this.stringAsyncClients) {
                for (ResourceRelation<Object> resourceRelation5 : this.stringAsyncEndpoints) {
                    resources = this.merge(env, resourceRelation, resourceRelation4, resourceRelation5);
                    for (MessageTestData data : messageTestData) {
                        this.suite.addTest((Test)new TextPlainTestCase(resourceRelation.getPrimaryResource(), (AsyncTestClient)resourceRelation4.getPrimaryResource(), (AsyncEndpoint)resourceRelation5.getPrimaryResource(), data, resources));
                    }
                }
            }
            for (ResourceRelation<TestClient> resourceRelation6 : this.byteAsyncClients) {
                for (ResourceRelation<Object> resourceRelation7 : this.byteAsyncEndpoints) {
                    resources = this.merge(env, resourceRelation, resourceRelation6, resourceRelation7);
                    this.suite.addTest((Test)new BinaryTestCase(resourceRelation.getPrimaryResource(), (AsyncTestClient)resourceRelation6.getPrimaryResource(), (AsyncEndpoint)resourceRelation7.getPrimaryResource(), resources));
                }
            }
            for (ResourceRelation<TestClient> resourceRelation8 : this.restAsyncClients) {
                for (ResourceRelation<Object> resourceRelation9 : this.restAsyncEndpoints) {
                    resources = this.merge(env, resourceRelation, resourceRelation8, resourceRelation9);
                    this.suite.addTest((Test)new RESTTestCase(resourceRelation.getPrimaryResource(), (AsyncTestClient)resourceRelation8.getPrimaryResource(), (AsyncEndpoint)resourceRelation9.getPrimaryResource(), restTestMessage1, resources));
                }
            }
        }
        for (ResourceRelation<Channel> resourceRelation : this.requestResponseChannels) {
            for (ResourceRelation<TestClient> resourceRelation10 : this.xmlRequestResponseClients) {
                for (ResourceRelation<Object> resourceRelation11 : this.echoEndpoints) {
                    resources = this.merge(env, resourceRelation, resourceRelation10, resourceRelation11);
                    for (MessageTestData data : messageTestData) {
                        for (XMLMessage.Type type : XMLMessage.Type.values()) {
                            if (type == XMLMessage.Type.SWA) continue;
                            this.suite.addTest((Test)new XMLRequestResponseMessageTestCase((RequestResponseChannel)resourceRelation.getPrimaryResource(), (RequestResponseTestClient)resourceRelation10.getPrimaryResource(), (InOutEndpoint)resourceRelation11.getPrimaryResource(), type, data, resources));
                        }
                    }
                }
            }
        }
    }

    public void build() {
        if (this.environments.isEmpty()) {
            this.build(new Object[0]);
        } else {
            for (Object[] env : this.environments) {
                this.build(env);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResourceList<T>
    implements Iterable<ResourceRelation<T>> {
        private final List<ResourceRelation<T>> list = new LinkedList<ResourceRelation<T>>();

        ResourceList() {
        }

        public void add(T primaryResource, Object ... relatedResources) {
            this.list.add(new ResourceRelation<T>(primaryResource, relatedResources));
        }

        @Override
        public Iterator<ResourceRelation<T>> iterator() {
            return this.list.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResourceRelation<T> {
        private final T primaryResource;
        private final Object[] relatedResources;

        public ResourceRelation(T primaryResource, Object ... relatedResources) {
            this.primaryResource = primaryResource;
            this.relatedResources = relatedResources;
        }

        public T getPrimaryResource() {
            return this.primaryResource;
        }

        public Object[] getRelatedResources() {
            return this.relatedResources;
        }
    }
}

