/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.axis2.endpoint;

import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.testkit.axis2.MessageContextValidator;
import org.apache.axis2.transport.testkit.axis2.endpoint.AxisTestEndpoint;
import org.apache.axis2.transport.testkit.axis2.endpoint.AxisTestEndpointContext;
import org.apache.axis2.transport.testkit.endpoint.AsyncEndpoint;
import org.apache.axis2.transport.testkit.endpoint.InOnlyEndpointSupport;
import org.apache.axis2.transport.testkit.message.AxisMessage;
import org.apache.axis2.transport.testkit.message.IncomingMessage;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisAsyncEndpoint
extends AxisTestEndpoint
implements AsyncEndpoint<AxisMessage> {
    private static Log log = LogFactory.getLog(AxisAsyncEndpoint.class);
    @Transient
    private AxisTestEndpointContext context;
    @Transient
    private MessageContextValidator[] validators;
    @Transient
    private InOnlyEndpointSupport<AxisMessage> support;

    @Setup
    private void setUp(AxisTestEndpointContext context, MessageContextValidator[] validators) {
        this.context = context;
        this.validators = validators;
        this.support = new InOnlyEndpointSupport();
    }

    protected InOnlyAxisOperation createOperation() {
        InOnlyAxisOperation operation = new InOnlyAxisOperation(new QName("default"));
        operation.setMessageReceiver(new MessageReceiver(){

            public void receive(MessageContext messageCtx) throws AxisFault {
                AxisAsyncEndpoint.this.receive(messageCtx);
            }
        });
        return operation;
    }

    void receive(MessageContext messageCtx) throws AxisFault {
        AxisMessage messageData;
        log.debug((Object)"MessageReceiver has been invoked");
        try {
            Assert.assertTrue((boolean)messageCtx.isServerSide());
            TransportInDescription transportIn = messageCtx.getTransportIn();
            Assert.assertNotNull((String)"transportIn not set on message context", (Object)transportIn);
            Assert.assertEquals((String)this.context.getTransportName(), (String)transportIn.getName());
            Assert.assertEquals((String)this.context.getTransportName(), (String)messageCtx.getIncomingTransportName());
            for (MessageContextValidator validator : this.validators) {
                validator.validate(messageCtx, false);
            }
            messageData = new AxisMessage(messageCtx);
        }
        catch (Throwable ex) {
            this.support.putException(ex);
            return;
        }
        this.support.putMessage(null, messageData);
    }

    @Override
    protected void onTransportError(Throwable ex) {
        this.support.putException(ex);
    }

    @Override
    public void clear() throws Exception {
        this.support.clear();
    }

    @Override
    public IncomingMessage<AxisMessage> waitForMessage(int timeout) throws Throwable {
        return this.support.waitForMessage(timeout);
    }
}

