/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.axis2.endpoint;

import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.UUID;
import junit.framework.Assert;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.event.TransportError;
import org.apache.axis2.transport.base.event.TransportErrorListener;
import org.apache.axis2.transport.base.event.TransportErrorSource;
import org.apache.axis2.transport.testkit.axis2.AxisServiceConfigurator;
import org.apache.axis2.transport.testkit.axis2.endpoint.AxisTestEndpointContext;
import org.apache.axis2.transport.testkit.channel.Channel;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.TearDown;
import org.apache.axis2.transport.testkit.tests.Transient;
import org.apache.axis2.transport.testkit.util.LogManager;

@Name(value="axis")
public abstract class AxisTestEndpoint {
    @Transient
    private AxisTestEndpointContext context;
    @Transient
    private TransportErrorSource transportErrorSource;
    @Transient
    private TransportErrorListener errorListener;
    @Transient
    AxisService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Setup
    private void setUp(LogManager logManager, AxisTestEndpointContext context, Channel channel, AxisServiceConfigurator[] configurators) throws Exception {
        ArrayList params;
        String path;
        this.context = context;
        TransportListener listener = context.getTransportListener();
        if (listener instanceof TransportErrorSource) {
            this.transportErrorSource = (TransportErrorSource)listener;
            this.errorListener = new TransportErrorListener(){

                public void error(TransportError error) {
                    AxisService s = error.getService();
                    if (s == null || s == AxisTestEndpoint.this.service) {
                        AxisTestEndpoint.this.onTransportError(error.getException());
                    }
                }
            };
            this.transportErrorSource.addErrorListener(this.errorListener);
        } else {
            this.transportErrorSource = null;
        }
        try {
            path = new URI(channel.getEndpointReference().getAddress()).getPath();
        }
        catch (URISyntaxException ex) {
            path = null;
        }
        String serviceName = path != null && path.startsWith("/services/") ? path.substring("/services".length() + 1) : "TestService-" + UUID.randomUUID();
        this.service = new AxisService(serviceName);
        this.service.addOperation(this.createOperation());
        if (configurators != null) {
            for (AxisServiceConfigurator configurator : configurators) {
                configurator.setupService(this.service, false);
            }
        }
        if (!(params = this.service.getParameters()).isEmpty()) {
            PrintWriter log = new PrintWriter(logManager.createLog("service-parameters"), false);
            try {
                for (Parameter param : params) {
                    log.print(param.getName());
                    log.print("=");
                    log.println(param.getValue());
                }
            }
            finally {
                log.close();
            }
        }
        this.service.addParameter("supportSingleOperation", (Object)true);
        context.getAxisConfiguration().addService(this.service);
        if (!BaseUtils.isUsingTransport((AxisService)this.service, (String)context.getTransportName())) {
            Assert.fail((String)"The service has been disabled by the transport");
        }
    }

    @TearDown
    private void tearDown() throws Exception {
        if (this.transportErrorSource != null) {
            this.transportErrorSource.removeErrorListener(this.errorListener);
        }
        this.context.getAxisConfiguration().removeService(this.service.getName());
    }

    protected abstract AxisOperation createOperation();

    protected abstract void onTransportError(Throwable var1);
}

