/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import org.apache.axis2.transport.testkit.doclet.Dependency;
import org.apache.axis2.transport.testkit.doclet.Resource;
import org.apache.axis2.transport.testkit.doclet.ResourceInfo;

public class TestkitJavadocDoclet {
    private static File resourceInfoFile;

    public static LanguageVersion languageVersion() {
        return Standard.languageVersion();
    }

    public static int optionLength(String option) {
        if (option.equals("-resource-info")) {
            return 2;
        }
        return Standard.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return Standard.validOptions((String[][])options, (DocErrorReporter)reporter);
    }

    public static boolean start(RootDoc root) throws Exception {
        TestkitJavadocDoclet.parseOptions(root.options());
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(resourceInfoFile));
        ResourceInfo resourceInfo = (ResourceInfo)in.readObject();
        in.close();
        for (ClassDoc clazz : root.classes()) {
            List<Dependency> dependencies;
            String qualifiedName = clazz.qualifiedName();
            List<Resource> usedBy = resourceInfo.getUsedBy(qualifiedName);
            Resource resource = resourceInfo.getResource(qualifiedName);
            List<Dependency> list = dependencies = resource == null ? null : resource.getDependencies();
            if (dependencies == null && usedBy == null) continue;
            String rawCommentText = clazz.getRawCommentText();
            StringBuilder buffer = new StringBuilder(rawCommentText.trim().length() == 0 ? "No documentation available." : rawCommentText);
            buffer.append("<h2>Resource information</h2>");
            if (usedBy != null) {
                buffer.append("This resource is used by: ");
                boolean first = true;
                for (Resource r : usedBy) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(", ");
                    }
                    buffer.append("{@link ");
                    buffer.append(r.getType());
                    buffer.append("}");
                }
            }
            if (dependencies != null) {
                buffer.append("<h3>Dependencies</h3>");
                buffer.append("<dl>");
                for (Dependency dependency : dependencies) {
                    buffer.append("<dt>{@link ");
                    buffer.append(dependency.getType());
                    buffer.append("} (");
                    buffer.append(dependency.getMultiplicity());
                    buffer.append(")</dt><dd>");
                    String comment = dependency.getComment();
                    if (comment == null) {
                        buffer.append("(no documentation available)");
                    } else {
                        buffer.append(comment);
                    }
                    buffer.append("</dd>");
                }
                buffer.append("</dl>");
            }
            clazz.setRawCommentText(buffer.toString());
        }
        return Standard.start((RootDoc)root);
    }

    private static void parseOptions(String[][] options) {
        for (String[] option : options) {
            if (!option[0].equals("-resource-info")) continue;
            resourceInfoFile = new File(option[1]);
            System.out.println("Resource information is read from " + resourceInfoFile);
        }
    }
}

