/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.message;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RESTMessage {
    private final Parameter[] parameters;

    public RESTMessage(Parameter[] parameters) {
        this.parameters = parameters;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public String getQueryString() {
        StringBuilder buffer = new StringBuilder();
        for (Parameter parameter : this.parameters) {
            if (buffer.length() > 0) {
                buffer.append('&');
            }
            buffer.append(parameter.getKey());
            buffer.append('=');
            try {
                buffer.append(URLEncoder.encode(parameter.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("JRE doesn't know UTF-8!", e);
            }
        }
        return buffer.toString();
    }

    public static class Parameter {
        private final String key;
        private final String value;

        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object _obj) {
            if (_obj instanceof Parameter) {
                Parameter obj = (Parameter)_obj;
                return ObjectUtils.equals((Object)this.key, (Object)obj.key) && ObjectUtils.equals((Object)this.value, (Object)obj.value);
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.key).append((Object)this.value).toHashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

