/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.axis2.transport.testkit.tests.TestResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResourceSet {
    private static Log log = LogFactory.getLog(TestResourceSet.class);
    private final TestResourceSet parent;
    private final List<TestResource> unresolvedResources = new LinkedList<TestResource>();
    final List<TestResource> resolvedResources = new LinkedList<TestResource>();
    Status status = Status.UNRESOLVED;

    public TestResourceSet(TestResourceSet parent) {
        this.parent = parent;
    }

    public TestResourceSet() {
        this(null);
    }

    public void addResource(Object resource) {
        if (this.status != Status.UNRESOLVED) {
            throw new IllegalStateException();
        }
        this.unresolvedResources.add(new TestResource(resource));
    }

    public void addResources(Object ... resources) {
        for (Object resource : resources) {
            this.addResource(resource);
        }
    }

    public Object[] getResources() {
        if (this.status == Status.UNRESOLVED) {
            throw new IllegalStateException();
        }
        Object[] result = new Object[this.resolvedResources.size()];
        int i = 0;
        for (TestResource resource : this.resolvedResources) {
            result[i++] = resource.getInstance();
        }
        return result;
    }

    public void resolve() {
        if (this.status == Status.UNRESOLVED) {
            while (!this.unresolvedResources.isEmpty()) {
                this.resolveResource(this.unresolvedResources.get(0));
            }
            this.status = Status.RESOLVED;
        }
    }

    private void resolveResource(TestResource resource) {
        this.unresolvedResources.remove(resource);
        resource.resolve(this);
        this.resolvedResources.add(resource);
    }

    TestResource[] findResources(Class<?> clazz, boolean allowAutoCreate) {
        LinkedList<TestResource> result = new LinkedList<TestResource>();
        if (this.parent != null) {
            result.addAll(Arrays.asList(this.parent.findResources(clazz, false)));
        }
        for (TestResource resource : this.resolvedResources) {
            if (!clazz.isInstance(resource.getInstance())) continue;
            result.add(resource);
        }
        LinkedList<TestResource> unresolvedMatchingResources = new LinkedList<TestResource>();
        for (TestResource resource : this.unresolvedResources) {
            if (!clazz.isInstance(resource.getInstance())) continue;
            unresolvedMatchingResources.add(resource);
        }
        for (TestResource resource : unresolvedMatchingResources) {
            this.resolveResource(resource);
            result.add(resource);
        }
        if (allowAutoCreate && result.isEmpty()) {
            TestResource resource;
            try {
                Field field = clazz.getField("INSTANCE");
                resource = new TestResource(field.get(null));
            }
            catch (Throwable ex) {
                resource = null;
            }
            if (resource != null) {
                this.unresolvedResources.add(resource);
                this.resolveResource(resource);
                result.add(resource);
            }
        }
        return result.toArray(new TestResource[result.size()]);
    }

    public void setUp() throws Exception {
        this.resolve();
        if (this.status != Status.RESOLVED) {
            throw new IllegalStateException();
        }
        TestResourceSet.setUp(this.resolvedResources);
        this.status = Status.SETUP;
    }

    static List<TestResource> filterOnHasLifecycle(List<TestResource> resources) {
        ArrayList<TestResource> result = new ArrayList<TestResource>(resources.size());
        for (TestResource resource : resources) {
            if (!resource.hasLifecycle()) continue;
            result.add(resource);
        }
        return result;
    }

    static void setUp(List<TestResource> resources) throws Exception {
        if (!(resources = TestResourceSet.filterOnHasLifecycle(resources)).isEmpty()) {
            log.info((Object)("Setting up: " + resources));
            for (TestResource resource : resources) {
                resource.setUp();
            }
        }
    }

    public void tearDown() throws Exception {
        if (this.status != Status.SETUP) {
            throw new IllegalStateException();
        }
        TestResourceSet.tearDown(this.resolvedResources);
    }

    static void tearDown(List<TestResource> resources) throws Exception {
        if (!(resources = TestResourceSet.filterOnHasLifecycle(resources)).isEmpty()) {
            log.info((Object)("Tearing down: " + resources));
            ListIterator<TestResource> it = resources.listIterator(resources.size());
            while (it.hasPrevious()) {
                it.previous().tearDown();
            }
        }
    }

    public String toString() {
        return this.resolvedResources.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        UNRESOLVED,
        RESOLVED,
        SETUP,
        RECYCLED;

    }
}

