/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests.async;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.transport.testkit.channel.AsyncChannel;
import org.apache.axis2.transport.testkit.client.AsyncTestClient;
import org.apache.axis2.transport.testkit.endpoint.AsyncEndpoint;
import org.apache.axis2.transport.testkit.message.XMLMessage;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.tests.async.AsyncMessageTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="AsyncSOAPLarge")
public class LargeSOAPAsyncMessageTestCase
extends AsyncMessageTestCase<XMLMessage> {
    public LargeSOAPAsyncMessageTestCase(AsyncChannel channel, AsyncTestClient<XMLMessage> client, AsyncEndpoint<XMLMessage> endpoint, Object ... resources) {
        super(channel, client, endpoint, XMLMessage.Type.SOAP11.getContentType(), "UTF-8", resources);
    }

    @Override
    protected XMLMessage prepareMessage() throws Exception {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement root = factory.createOMElement(new QName("root"));
        for (int i = 0; i < 1000; ++i) {
            OMElement child = factory.createOMElement(new QName("child"));
            child.setText("text");
            root.addChild((OMNode)child);
        }
        return new XMLMessage(root, XMLMessage.Type.SOAP11);
    }

    @Override
    protected void checkMessageData(XMLMessage expected, XMLMessage actual) throws Exception {
        OMElement element = actual.getPayload();
        OMElement orgElement = expected.getPayload();
        LargeSOAPAsyncMessageTestCase.assertEquals((Object)orgElement.getQName(), (Object)element.getQName());
        LargeSOAPAsyncMessageTestCase.assertEquals((int)1000, (int)LargeSOAPAsyncMessageTestCase.countChildren(element));
    }

    private static int countChildren(OMElement element) {
        int count = 0;
        Iterator it = element.getChildElements();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }
}

