/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.mail.internet.ContentType;
import org.apache.axis2.transport.testkit.client.AsyncTestClient;
import org.apache.axis2.transport.testkit.client.ClientOptions;
import org.apache.axis2.transport.testkit.http.HttpChannel;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.Transient;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="java.net")
public class JavaNetClient
implements AsyncTestClient<byte[]> {
    private static final Log log = LogFactory.getLog(JavaNetClient.class);
    @Transient
    private HttpChannel channel;

    @Setup
    private void setUp(HttpChannel channel) {
        this.channel = channel;
    }

    @Override
    public ContentType getContentType(ClientOptions options, ContentType contentType) {
        return contentType;
    }

    @Override
    public void sendMessage(ClientOptions options, ContentType contentType, byte[] message) throws Exception {
        URL url = new URL(this.channel.getEndpointReference().getAddress());
        log.debug((Object)("Opening connection to " + url + " using " + URLConnection.class.getName()));
        try {
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Type", contentType.toString());
            if (contentType.getBaseType().equals("text/xml")) {
                connection.setRequestProperty("SOAPAction", "");
            }
            OutputStream out = connection.getOutputStream();
            out.write(message);
            out.close();
            if (connection instanceof HttpURLConnection) {
                String headerValue;
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                log.debug((Object)("Response code: " + httpConnection.getResponseCode()));
                log.debug((Object)("Response message: " + httpConnection.getResponseMessage()));
                int i = 0;
                while ((headerValue = httpConnection.getHeaderField(i)) != null) {
                    String headerName = httpConnection.getHeaderFieldKey(i);
                    if (headerName != null) {
                        log.debug((Object)(headerName + ": " + headerValue));
                    } else {
                        log.debug((Object)headerValue);
                    }
                    ++i;
                }
            }
            InputStream in = connection.getInputStream();
            IOUtils.copy((InputStream)in, (OutputStream)System.out);
            in.close();
        }
        catch (IOException ex) {
            log.debug((Object)"Got exception", (Throwable)ex);
            throw ex;
        }
    }
}

