/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.name;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.axis2.transport.testkit.Adapter;
import org.apache.axis2.transport.testkit.name.Key;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.name.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameUtils {
    public static Map<String, String> getNameComponents(Object object) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        NameUtils.getNameComponents(result, object);
        return result;
    }

    private static <A extends Annotation> A getAnnotationInherited(Class<?> type, Class<A> annotationClass) {
        A ann = type.getAnnotation(annotationClass);
        if (ann != null) {
            return ann;
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null && (ann = NameUtils.getAnnotationInherited(superClass, annotationClass)) != null) {
            return ann;
        }
        for (Class<?> iface : type.getInterfaces()) {
            ann = NameUtils.getAnnotationInherited(iface, annotationClass);
            if (ann == null) continue;
            return ann;
        }
        return null;
    }

    public static void getNameComponents(Map<String, String> map, Object object) {
        while (object instanceof Adapter) {
            object = ((Adapter)object).getTarget();
        }
        Class<?> clazz = object.getClass();
        Key key = NameUtils.getAnnotationInherited(clazz, Key.class);
        if (key != null) {
            Name name = clazz.getAnnotation(Name.class);
            if (name == null) {
                String className = clazz.getName();
                map.put(key.value(), className.substring(className.lastIndexOf(46) + 1));
            } else {
                map.put(key.value(), name.value());
            }
        }
        for (Method method : clazz.getMethods()) {
            Object relatedObject;
            Key key2 = method.getAnnotation(Key.class);
            Named named = method.getAnnotation(Named.class);
            if (key2 == null && named == null) continue;
            try {
                method.setAccessible(true);
                relatedObject = method.invoke(object, new Object[0]);
            }
            catch (Throwable ex) {
                throw new Error("Error invoking " + method, ex);
            }
            if (relatedObject == null) continue;
            if (key2 != null) {
                map.put(key2.value(), relatedObject.toString());
                continue;
            }
            NameUtils.getNameComponents(map, relatedObject);
        }
    }
}

