/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests;

import javax.mail.internet.ContentType;
import org.apache.axis2.transport.testkit.Adapter;
import org.apache.axis2.transport.testkit.MessageExchangeValidator;
import org.apache.axis2.transport.testkit.client.ClientOptions;
import org.apache.axis2.transport.testkit.client.TestClient;
import org.apache.axis2.transport.testkit.tests.ManagedTestCase;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MessageTestCase
extends ManagedTestCase {
    private static final Log log = LogFactory.getLog(MessageTestCase.class);
    protected final ContentType contentType;
    protected final ClientOptions options;
    @Transient
    private MessageExchangeValidator[] validators;

    public MessageTestCase(TestClient client, ContentType contentType, String charset, Object ... resources) {
        super(resources);
        if (client instanceof Adapter) {
            this.addResource(((Adapter)((Object)client)).getTarget());
        } else {
            this.addResource(client);
        }
        this.contentType = contentType;
        try {
            this.options = new ClientOptions(client, contentType, charset);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
        this.addResource(this.options);
        this.addResource((Object)this);
    }

    @Setup
    private void setUp(MessageExchangeValidator[] validators) {
        this.validators = validators;
    }

    protected void runTest() throws Throwable {
        for (MessageExchangeValidator validator : this.validators) {
            validator.beforeSend();
        }
        this.doRunTest();
        for (MessageExchangeValidator validator : this.validators) {
            log.debug((Object)("Invoking message exchange validator " + validator.getClass().getName()));
            validator.afterReceive();
        }
    }

    protected abstract void doRunTest() throws Throwable;
}

