/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis2.transport.testkit.tests.TestResource;
import org.apache.axis2.transport.testkit.tests.TestResourceSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestResourceSetTransition {
    private static final Log log = LogFactory.getLog(TestResourceSetTransition.class);
    private final TestResourceSet old;
    private final TestResourceSet target;
    private final List<TestResource> oldResourcesToTearDown;
    private final List<TestResource> resourcesToSetUp;
    private final List<TestResource> resourcesToKeep;

    public TestResourceSetTransition(TestResourceSet old, TestResourceSet target) {
        this.old = old;
        this.target = target;
        target.resolve();
        if (target.status != TestResourceSet.Status.RESOLVED) {
            throw new IllegalStateException();
        }
        if (old.status != TestResourceSet.Status.SETUP) {
            throw new IllegalStateException();
        }
        this.oldResourcesToTearDown = new LinkedList<TestResource>();
        this.resourcesToSetUp = new LinkedList<TestResource>(target.resolvedResources);
        this.resourcesToKeep = new LinkedList<TestResource>();
        block0: for (TestResource oldResource : TestResourceSet.filterOnHasLifecycle(old.resolvedResources)) {
            Iterator<TestResource> it = this.resourcesToSetUp.iterator();
            while (it.hasNext()) {
                TestResource resource = it.next();
                if (!resource.equals(oldResource)) continue;
                it.remove();
                resource.recycle(oldResource);
                this.resourcesToKeep.add(oldResource);
                continue block0;
            }
            this.oldResourcesToTearDown.add(oldResource);
        }
    }

    public void tearDown() throws Exception {
        if (this.old.status != TestResourceSet.Status.SETUP) {
            throw new IllegalStateException();
        }
        TestResourceSet.tearDown(this.oldResourcesToTearDown);
        this.old.status = TestResourceSet.Status.RECYCLED;
    }

    public void setUp() throws Exception {
        if (this.target.status != TestResourceSet.Status.RESOLVED) {
            throw new IllegalStateException();
        }
        log.debug((Object)("Keeping: " + this.resourcesToKeep));
        TestResourceSet.setUp(this.resourcesToSetUp);
        this.target.status = TestResourceSet.Status.SETUP;
    }
}

