/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests.echo;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.transport.testkit.MessageTestData;
import org.apache.axis2.transport.testkit.channel.RequestResponseChannel;
import org.apache.axis2.transport.testkit.client.RequestResponseTestClient;
import org.apache.axis2.transport.testkit.endpoint.InOutEndpoint;
import org.apache.axis2.transport.testkit.message.XMLMessage;
import org.apache.axis2.transport.testkit.name.Key;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.name.Named;
import org.apache.axis2.transport.testkit.tests.echo.RequestResponseMessageTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="EchoXML")
public class XMLRequestResponseMessageTestCase
extends RequestResponseMessageTestCase<XMLMessage, XMLMessage> {
    private final XMLMessage.Type xmlMessageType;
    private final MessageTestData data;

    public XMLRequestResponseMessageTestCase(RequestResponseChannel channel, RequestResponseTestClient<XMLMessage, XMLMessage> client, InOutEndpoint endpoint, XMLMessage.Type xmlMessageType, MessageTestData data, Object ... resources) {
        super(channel, client, endpoint, xmlMessageType.getContentType(), data.getCharset(), resources);
        this.xmlMessageType = xmlMessageType;
        this.data = data;
    }

    @Key(value="messageType")
    public XMLMessage.Type getXmlMessageType() {
        return this.xmlMessageType;
    }

    @Named
    public MessageTestData getData() {
        return this.data;
    }

    @Override
    protected XMLMessage prepareRequest() throws Exception {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement orgElement = factory.createOMElement(new QName("root"));
        orgElement.setText(this.data.getText());
        return new XMLMessage(orgElement, this.xmlMessageType);
    }

    @Override
    protected void checkResponse(XMLMessage request, XMLMessage response) throws Exception {
        OMElement orgElement = request.getPayload();
        OMElement element = response.getPayload();
        XMLRequestResponseMessageTestCase.assertEquals((Object)orgElement.getQName(), (Object)element.getQName());
        XMLRequestResponseMessageTestCase.assertEquals((String)orgElement.getText(), (String)element.getText());
    }
}

