/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.tests.misc;

import javax.mail.internet.ContentType;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.testkit.axis2.client.AxisAsyncTestClient;
import org.apache.axis2.transport.testkit.axis2.client.AxisTestClientContext;
import org.apache.axis2.transport.testkit.axis2.endpoint.AxisTestEndpoint;
import org.apache.axis2.transport.testkit.axis2.endpoint.AxisTestEndpointContext;
import org.apache.axis2.transport.testkit.channel.AsyncChannel;
import org.apache.axis2.transport.testkit.client.ClientOptions;
import org.apache.axis2.transport.testkit.message.AxisMessage;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.tests.ManagedTestCase;
import org.apache.axis2.transport.testkit.tests.TestResourceSet;

@Name(value="MinConcurrency")
public class MinConcurrencyTest
extends ManagedTestCase {
    private final AsyncChannel[] channels;
    private final int messages;
    private final boolean preloadMessages;
    private int concurrencyReached;
    private final Object concurrencyReachedLock = new Object();
    private final Object shutdownAwaitLock = new Object();

    public MinConcurrencyTest(AsyncChannel[] channels, int messages, boolean preloadMessages, Object ... resources) {
        super(resources);
        this.addResource(AxisTestClientContext.INSTANCE);
        this.addResource(AxisTestEndpointContext.INSTANCE);
        this.channels = channels;
        this.messages = messages;
        this.preloadMessages = preloadMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        int endpointCount = this.channels.length;
        int expectedConcurrency = endpointCount * this.messages;
        final MessageReceiver messageReceiver = new MessageReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receive(MessageContext msgContext) throws AxisFault {
                Object object = MinConcurrencyTest.this.concurrencyReachedLock;
                synchronized (object) {
                    MinConcurrencyTest.this.concurrencyReached++;
                    MinConcurrencyTest.this.concurrencyReachedLock.notifyAll();
                }
                try {
                    MinConcurrencyTest.this.shutdownAwaitLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        TestResourceSet[] clientResourceSets = new TestResourceSet[endpointCount];
        TestResourceSet[] endpointResourceSets = new TestResourceSet[endpointCount];
        try {
            Object object;
            for (int i = 0; i < endpointCount; ++i) {
                TestResourceSet clientResourceSet = new TestResourceSet(this.getResourceSet());
                AsyncChannel channel = this.channels[i];
                clientResourceSet.addResource(channel);
                AxisAsyncTestClient client = new AxisAsyncTestClient(false);
                clientResourceSet.addResource(client);
                clientResourceSet.setUp();
                clientResourceSets[i] = clientResourceSet;
                TestResourceSet endpointResourceSet = new TestResourceSet(clientResourceSet);
                endpointResourceSet.addResource(new AxisTestEndpoint(){

                    protected AxisOperation createOperation() {
                        InOnlyAxisOperation operation = new InOnlyAxisOperation(new QName("in"));
                        operation.setMessageReceiver(messageReceiver);
                        return operation;
                    }

                    protected void onTransportError(Throwable ex) {
                    }
                });
                if (!this.preloadMessages) {
                    endpointResourceSet.setUp();
                    endpointResourceSets[i] = endpointResourceSet;
                }
                for (int j = 0; j < this.messages; ++j) {
                    ClientOptions options = new ClientOptions(client, new ContentType("text/xml"), "UTF-8");
                    AxisMessage message = new AxisMessage();
                    message.setMessageType("text/xml");
                    SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
                    SOAPEnvelope envelope = factory.getDefaultEnvelope();
                    message.setEnvelope(envelope);
                    client.sendMessage(options, new ContentType(message.getMessageType()), message);
                }
                if (!this.preloadMessages) continue;
                endpointResourceSet.setUp();
                endpointResourceSets[i] = endpointResourceSet;
            }
            long startTime = System.currentTimeMillis();
            while (this.concurrencyReached < expectedConcurrency && System.currentTimeMillis() < startTime + 5000L) {
                object = this.concurrencyReachedLock;
                synchronized (object) {
                    this.concurrencyReachedLock.wait(5000L);
                }
            }
            object = this.shutdownAwaitLock;
            synchronized (object) {
                this.shutdownAwaitLock.notifyAll();
            }
            if (this.concurrencyReached < expectedConcurrency) {
                MinConcurrencyTest.fail((String)("Concurrency reached is " + this.concurrencyReached + ", but expected " + expectedConcurrency));
            }
        }
        finally {
            for (int i = 0; i < endpointCount; ++i) {
                if (endpointResourceSets[i] != null) {
                    endpointResourceSets[i].tearDown();
                }
                if (clientResourceSets[i] == null) continue;
                clientResourceSets[i].tearDown();
            }
        }
    }
}

